#!/usr/bin/env php
<?php
declare(ticks=1);
pcntl_signal(SIGCHLD, "sig_child");

define('PROCESS_COUNT', '5');
$children = array();

for($i = 0; $i < PROCESS_COUNT; $i++) {
  if(($pid = pcntl_fork()) == 0) {
    exit(child_main());
  }
  else {
    $children[] = $pid;
  }  
}

while($children) {
  sleep(10);  // lub wykonaj inne operacje w procesie rodzica
}
pcntl_alarm(0);

function child_main() 
{
  sleep(rand(0, 10));  // lub wykonaj inne operacje w procesie potomnym
  return  1;
}

function sig_child($signal) 
{
  global $children;
  pcntl_signal(SIGCHLD, "sig_child");
  fputs(STDERR, "Przechwycony sygna SIGCHLD.\n");
  while(($pid = pcntl_wait($status, WNOHANG)) > 0) {
    $children = array_diff($children, array($pid));
    if(!pcntl_wifexited($status)) {
      fputs(STDERR, "Zebrany przerwany pid $pid.\n");
    }
    else {
      fputs(STDERR, "Zebrany zakoczony pid $pid.\n");
    }
  }
}
?>
