<?php
class TiedArray implements ArrayAccess, Iterator {
  private $db;
  private $current;
  function __construct($file) {
    $this->db = dba_popen($file, "c", "flatfile");
    if(!$this->db) {
      throw new Exception("Nie mona otworzy $file");
    }
  }
  function __destruct()
  {
    dba_close($this->db);
  }
  function offsetExists($index) {
    return dba_exists($index, $this->db);
  }
  function offsetGet($index) {
    return unserialize(dba_fetch($index, $this->db));
  }
  function offsetSet($index, $newval) {
    dba_replace($index, serialize($newval), $this->db);
    return $newval;
  }
  function offsetUnset($index) {
    return dba_delete($index, $this->db);
  }
  function rewind() {
    $this->current = dba_firstkey($this->db);
  }
  function current() {
    $key = $this->current;
    if($key !== false) {
      return $this->offsetGet($key);
    }
  }
  function next() {
    $this->current = dba_nextkey($this->db);
  }
  function valid() {
    return ($this->current == false)?false:true;
  }
  function key() {
    return $this->current;
  }
}
?>
