void exception_error_cb(int type, const char *error_filename,
                        const uint error_lineno, const char *format,
                        va_list args)
{
    char buffer;
    int buffer_len;
    TSRMLS_FETCH();

    if(type == E_WARNING|| type == E_USER_WARNING) {
        buffer_len = vsprintf(&buffer, PG(log_errors_max_len), format, args);
        zend_throw_exception(zend_exception_get_default(), buffer, type);
        free(buffer);
    }
    else {
        EEG(old_error_cb)(type, error_filename, error_lineno, format, args);
    }
    return;
}
