int main(int argc, char **argv)
{
    int exit_status = SUCCESS;
    zend_file_handle file_handle;
    int retval = FAILURE;

    signal(SIGPIPE, SIG_IGN); /* zignorowanie klientw rozczajcych si */
    sapi_startup (&cgi_sapi_module);
    cgi_sapi_module.executable_location = argv[0];

    if (php_module_startup(&cgi_sapi_module, NULL, 0) == FAILURE) {
        return FAILURE;
    }
    zend_first_try {
        SG(server_context) = (void *) 1; /* uniknicie testu server_context==NULL */
        init_request_info(TSRMLS_C);
        file_handle.type = ZEND_HANDLE_FILENAME;
        file_handle.filename = SG(request_info).path_translated;
        file_handle.handle.fp = NULL;
        file_handle.opened_path = NULL;
        file_handle.free_filename = 0;

        if (php_request_startup(TSRMLS_C) == FAILURE) {
            php_module_shutdown(TSRMLS_C);
            return FAILURE;
        }
        retval = php_fopen_primary_script(&file_handle TSRMLS_CC);
        if (retval == FAILURE && file_handle.handle.fp == NULL) {
            SG(sapi_headers).http_response_code = 404;
            PUTS("Nie okrelono pliku wejciowego.\n");
            php_request_shutdown((void *) 0);
            php_module_shutdown(TSRMLS_C);
            return FAILURE;
        }
        php_execute_script(&file_handle TSRMLS_CC);
        if (SG(request_info).path_translated) {
            char *path_translated;
            path_translated = strdup(SG(request_info).path_translated);
            efree(SG(request_info).path_translated);
            SG(request_info).path_translated = path_translated;
        }
        php_request_shutdown((void*) 0);
        if (exit_status == 0) {
            exit_status = EG(exit_status);
        }
        if (SG(request_info).path_translated) {
            free(SG(request_info).path_translated);
            SG(request_info).path_translated = NULL;
        }
    }   zend_catch {
        exit_status = 255;
    }   zend_end_try();
    php_module_shutdown(TSRMLS_C);
    sapi_shutdown();
    return exit status;
}

