PHP_FUNCTION(mmap_open)
{
    char *filename;
    long filename_len;
    long file_length;
    int fd;
    php_stream * stream;
    void *mpos;

    struct mmap_stream_data *data;

    if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "sl",
                            &filename, &filename_len, &file_length) == FAILURE)
    {
        return;
    }
    if((fd = open(filename, 0_RDWR)) < -1) {
        RETURN_FALSE;
    }
    if((mpos = mmap(NULL, file_length, PROT_READ|PROT_WRITE, MAP_PRIVATE, fd, 0))
         == (void *) -1) {
        close(fd);
        RETURN_FALSE;
    }
    data = emalloc(sizeof(struct mmap_stream_data));
    data->base_pos = mpos;
    data->current_pos = mpos;
    data->len = file_length;
    close(fd);
    stream = php_stream_alloc(&mmap_ops, data, NULL, "r+");
    php_stream_to_zval (stream, return_value);
}
