<?php

require_once "PHPUnit/Framework/TestCase.php";

// WebAuthCase jest klas abstrakcyjn w ktrej tylko ustawiamy 
// url do testowania, ale nie uruchamiamy testw.
class WebAuthTestCase extends PHPUnit_Framework_TestCase{
  public $curl_handle;
  public $url;
  function __construct($name) {
    parent::__construct($name);
  }
  function setUp() {
    // inicjacja curl
    $this->curl_handle = curl_init();
    // ustawienie curl w taki sposb, aby zwracaa nam wynik po wywoaniu curl_exec
    curl_setopt($this->curl_handle, CURLOPT_RETURNTRANSFER, 1);
    // ustawienie adresu url
    $this->url = "http://devel.omniti.com/auth.php";
    curl_setopt($this->curl_handle, CURLOPT_URL, $this->url);
  }
  function tearDown() {
    // zamknicie sesji curl po zakoczeniu pracy
    curl_close($this->curl_handle);
  }
}

// WebGoodAuthTestCase implementuje test udanej autoryzacji
class WebGoodAuthTestCase extends WebAuthTestCase {
  function __construct($name) {
    parent::__construct($name);
  }
  function testGoodAuth() {
    $user = 'george';
    // tworzenie cookie  user=NAME
    $cookie = "user=$user;";
    // wysanie cookie
    curl_setopt($this->curl_handle, CURLOPT_COOKIE, $cookie);
    // wysanie wywoania
    $ret = curl_exec($this->curl_handle);
    $this->assertRegExp("/<!-- crafted for $user -->/", $ret);
  }
}

// WebBadAuthTestCase implementuje test nieudanej autoryzacji
class WebBadAuthTestCase extends WebAuthTestCase {
  function __construct($name) {
    parent::__construct($name);
  }
  function testBadAuth() {
    // brak przesanego cookie
    curl_setopt($this->curl_handle, CURLOPT_COOKIE, $cookie);
    // wysanie dania
    $ret = curl_exec($this->curl_handle);
    if(preg_match("/<!-- crafted for /", $ret)) {
      $this->fail();
    }
    else {
      $this->pass();
    }
  }
}

if(realpath($_SERVER['PHP_SELF']) == __FILE__) {
  require_once "PHPUnit/Framework/TestSuite.php";
  require_once "PHPUnit/TextUI/TestRunner.php";

  $suite = new PHPUnit_Framework_TestSuite('WebGoodAuthTestCase');
  $suite->addTestSuite("WebBadAuthTestCase");
  PHPUnit_TextUI_TestRunner::run($suite);
}
?>

