<?php
require_once "PHPUnit/Framework/TestListener.php";

class EmailAddressListener implements PHPUnit_Framework_TestListener {
  public $owner = "george@omniti.com";
  public  $message = '';

  public function addError(PHPUnit_Framework_Test $test, Exception $e) 
  {
    $this->message .= "Bd w ".$test->getName()."\n";
    $this->message .= "Komunikat bdu: ".$e->getMessage()."\n";
  }

  public function addFailure(PHPUnit_Framework_Test  $test, 
                      PHPUnit_Framework_AssertionFailedError $e) 
  {
    $this->message .= "Niepowodzenie w ".$test->getName()."\n";
    $this->message .= "Komunikat bdu: ".$e->getMessage()."\n";
  }

  public function startTest(PHPUnit_Framework_Test $test)
  {
    $this->message .= "Pocztek testu ".$test->getName()."\n";
  }

  public function endTest(PHPUnit_Framework_Test $test) 
  {
    if($this->message) {
     $owner = isset($test->owner)?$test->owner:$this->owner;
     $date = strftime("%D %H:%M:%S");
     mail($this->owner, "Nieudane wykonanie testu $date", $this->message);
     echo "\n($this->owner, \"Dnia $date test nie powid si\", $this->message)";
    }
  }
}

require_once "TestHarness.php";


require_once "PHPUnit/TextUI/TestRunner.php";
$suite = new TestHarness();
$suite->register("EmailAddress.phpt");
$suite->register("Text/Word.phpt");
myTestRunner($suite);

require_once "PHPUnit/TextUI/ResultPrinter.php";
require_once "PHPUnit/Framework/TestResult.php";

function myTestRunner($suite) 
{
  $result = new PHPUnit_Framework_TestResult;
  $textPrinter = new PHPUnit_TextUI_ResultPrinter;
  $result->addListener($textPrinter);
  $result->addListener(new EmailAddressListener);
  $suite->run($result);
  $textPrinter->printResult($result);
}
?>
