<?php
require_once "PHPUnit/Framework/TestCase.php";

class EmailAddressTestCase extends PHPUnit_Framework_TestCase{
  protected $email;
  protected $localPart;
  protected $domain;

  function __construct($name) {
    parent::__construct($name);
  }
  function setUp() {
    $this->email = new EmailAddress("george@omniti.com");
    $this->localPart = 'george';
    $this->domain = 'omniti.com';
  }
  function testLocalPart() {
    $this->assertEquals($this->email->localPart, $this->localPart, 
       "lokalna cz: ".$this->email->localPart.
       " z ".$this->email->address." != $this->localPart");
  }
  function testDomain() {
    $this->assertEquals($this->email->domain, $this->domain, 
        "domena: ".$this->email->domain.
        " z $this->email->address != $this->domain");
  }
}
?>
