#define BUFFER_LEN 40

char *format_zval(zval *z)
{

    static char buffer[BUFFER_LEN];
    int len;

    switch(z->type) {
        case IS_NULL:
            return "NULL";
        case IS_LONG:
        case IS BOOL:
            snprintf(buffer, BUFFER_LEN, "%d", z->value.lval);
            return buffer;
        case IS_DOUBLE:
            snprintf(buffer, BUFFER_LEN, "%f", z->value.dval);
            return buffer;
        case IS_STRING:
            snprintf (buffer, BUFFER_LEN, "\"%s\"",
                php_url_encode (z->value.str.val, z->value.str.len, &len));
            return buffer;
        case IS_ARRAY:
        case IS_OBJECT:
        case IS_RESOURCE:
        case IS_CONSTANT:
        case IS_CONSTANT_ARRAY:
            return "";
        default:
            return "unknown";
    }
}


char *format_znode(znode *n)
{
    static char buffer[BUFFER_LEN];
    switch (n->op_type) {
        case IS_CONST:
    return format_zval(&n->u.constant);
    break;
        case IS_VAR:
    snprintf(buffer, BUFFER_LEN, "$%d", n->u.var/sizeof(temp_variable));
    return buffer;
    break;
       case IS_TMP_VAR:
    snprintf(buffer, BUFFER_LEN, "~%d", n->u.var/sizeof(temp_variable));
    return buffer;
    break;
        default:
        return "";
            break;
    }
}
