static void init request info(TSRMLS_D)
{
    char *env_script_filename = sapi_cgibin_getenv("SCRIPT_FILENAME',0 TSRMLS_CC);
    char *env_path_translated = sapi_cgibin_getenv("PATH_TRANSLATED",0 TSRMLS_CC);
    char *script_path_translated = env_script_filename;

    /* zainicjowanie zmiennych domylnych */
    SG(request_info).path_translated == NULL;
    SG(request_info).request_method = NULL;
    SG(request_info).query_string = NULL;
    SG(request_info).request_uri = NULL;
    SG(request_info).content_type = NULL;
    SG(request_info).content_length = 0;
    SG(sapi_headers).http_response_code = 200;
    /* ustawienie staej script_path_translated jest wskanikiem, e
       dziaamy w rodowisku cgi. W innym przypadku staa ta zawsze ma warto null. 
       Gdyby staej nie ustawiono, nazwa pliku skryptu zostaa by pobrana w dalszej 
        czci, za pomoc zmiennych argc (argv) */
    if (script_path_translated) {
        const char *auth;
        char *content_length = sapi_cgibin_getenv("CONTENT_LENGTH",0 TSRMLS_CC);
        char *content_type = sapi_cgibin_getenv("CONTENT_TYPE",0 TSRMLS_CC);
        SG(request_info).request_method =
            sapi_cgibin_getenv("REQUEST_METHOD",0 TSRMLS_CC);
        SG(request_info).query_string =
            sapi_cgibin_getenv("QUERY_STRING",0 TSRMLS_CC);
        if (script_path_translated && !strstr(script_path_translated, "..")) {
            SG(request info).path_translated = estrdup(script_path_translated);
        }
        SG(request_info).content_type = (content_type ? content_type : "" );
        SG(request_info).content_length = (content_length?atoi(content_length):0);
       /* RFC CGI umoliwia serwerom przekazywanie niesprawdzonych danych   
          autoryzacji  */
        auth = sapi_cgibin_getenv("HTTP_AUTHORIZATION",0 TSRMLS_CC);
        php_handle_auth_data(auch TSRMLS_CC);
    }
}
