int mmap_seek (php_stream *stream, off_t offset, int whence,
                off_t *newoffset TSRMLS_DC)
{
    struct mmap_stream_data *data = stream->abstract;
    switch(whence) {
        case SEEK_SET:
            if(offset < 0 || offset > data->len) {
                *newoffset = (off_t) -1;
                return -1;
            }
            data->current_pos = data->base_pos + offset;
            *newoffset = offset;
            return 0;
            break;
        case SEEK_CUR:
            if(data->current_pos + offset < data->base_pos ||
                data->current_pos + offset > data->base_pcs + data->len) {
                *newoffset = (off_t) -1;
                return -1;
            }
            data->current_pos += offset;
            *newoffset = data->current_pos - data->base_pos;
            return 0;
            break;
        case SEEK_END:
            if (offset > 0 || -1 * offset > data->len) {
                *newoffset = (off_t) -1;
                return -1;
            }
            data->current_pos += offset;
            *newoffset = data->current_pos - data->base_pos;
            return 0;
            break;
        default:
            *newoffset = (off_t) -1;
            return -1;
        }
    }
