<?php
require_once 'XML/RPC.php';
if($argc != 2) {
  print "Must specify a url.\n";
  exit;
}
$url = parse_url($argv[1]);

$client = new XML_RPC_Client($url['path'], $url['host']);
$msg = new XML_RPC_Message('system.listMethods');
$result = $client->send($msg);
if ($result->faultCode()) {
    echo "Error\n";
}
$methods = XML_RPC_decode($result->value());
foreach($methods as $method) {
  $message = new XML_RPC_Message('system.methodSignature', 
                                 array(new XML_RPC_Value($method)));
  $response = $client->send($message)->value();
  print "Method $method:\n";
  $docstring = XML_RPC_decode(
                 $client->send(
                   new XML_RPC_Message('system.methodHelp', 
                                       array(new XML_RPC_Value($method))
                                      )
                 )->value()
               );
  if($docstring) {
    print "$docstring\n";
  } 
  else {
    print "NO DOCSTRING\n";
  }
  $response = $client->send($message)->value();
  if($response->kindOf() == 'array') {
    $signatures = XML_RPC_decode($response);
    for($i = 0; $i < count($signatures); $i++) {
      $return = array_shift($signatures[$i]);
      $params = implode(", ", $signatures[$i]);
      print "Signature #$i: $return $method($params)\n";
    }
  } else {
    print "NO SIGNATURE\n";
  }
  print "\n";
}
?>
