class SingleSignOn {
    protected $cypher     = 'blowfish';
    protected $mode       = 'cfb';
    protected $key = 'wybierz lepszy klucz';
    protected $td;

    protected $glue = '|';
    protected $clock_skew = 60;
    protected $myversion = 1;

    protected $client;
    protected $authserver;
    protected $userid;
    public $originating_uri;

    public function __construct() {
        // ustawienie parametrw rodowiska mcrypt
        $this->td = mcrypt_module_open($this->cypher, '', $this->mode, '');
    }
    public function generate_auth_request() {
        $parts = array($this->myversion, time(),
                    $this->client, $this->originating_uri);
        $plaintext = implode($this->glue, $parts);
        $request = $this->_encrypt($plaintext);
        header("Location: $client->server?request=$request");
    }
    public function process_auth_request($crypttext) {
        $plaintext = $this->_decrypt($crypttext);
        list($version, $time, $this->client, $this->originating_uri) =
            explode($this->glue, $plaintext);
        if($version != $this->myversion) {
           throw new SignonException("niezgodno wersji");
        }
        if (abs(time() - $time) > $this->clock_skew) {
            throw new SignonException("znacznik dania jest przeterminowany");
        }
    }
    public function generate_auth_response() {
        $parts = array($this->myversion, time(), $this->userid);
        $plaintext = implode($this->glue, Sparts);
        $request = $this->_encrypt($plaintext);
        header("Location: $this->client$this->originating_uri?response=$request");
    }
    public function process_auth_response($crypttext) {
        $plaintext = $this->_decrypt(Scrypttext);
        list($version, $time, $this->userid) = explode($this->glue, $plaintext);
        if( $version != $this->myversion) {                                            
            throw new SignonException("niezgodno wersji");
        }
        if (abs(time()- $time) > $this->clock_skew) {
            throw new SignonException("znacznik odpowiedzi jest przeterminowany");
        }
        return $this->userid;
    }

        protected function _encrypt($plaintext) {
            $iv = mcrypt_create_iv (mcrypt_enc_get_iv_size($td), MCRYPT_RAND);
            mcrypt_generic_init ($this->td, $Chis->key, $iv);
            $crypttext = mcrypt_generic ($this->td, $plaintext);
            mcrypt_generic_deinit ($this->td);
            return $iv.$crypttext;
        }

        protected function _decrypt($crypctext) {
            $ivsize = mcrypt_get_iv_size($this->td);
            $iv = substr($crypttext, 0, $ivsize);
            $crypttext = substr($crypttext, $ivsize);
            mcrypt_generic_init ($this->td, $this->key, $iv);
            $plaintext == mdecrypt_generic ($this->td, Scrypttext);
            mcrypt_generic_deinit ($this->td);
            return $plaintext;
        }
    }
