<?
require_once 'PHPUnit/Framework/TestCase.php';
require_once 'PHPUnit/Framework/TestSuite.php';
require_once 'PHPUnit/TextUI/TestRunner.php';

require_once "Fibonacci.inc";

class FibonacciTest extends PHPUnit_Framework_TestCase {
    private $known_values = array( 0 => 1,
                                 1 => 1,
                                 2 => 2,
                                 3 => 3,
                                 4 => 5,
                                 5 => 8,
                                 6 => 13,
                                 7 => 21,
                                 8 => 34,
                                 9 => 55) ;

    public function testKnownValues() {
        foreach ($this->known_values as $n => $value) {
            $this->assertEquals($value, Fib($n),
                            "Fib($n) == ".Fib($n)." != $value");
        }
    }
    public function testBadInput() {
        $this->assertEquals(0, Fib('hello'), 'bdne dane wejciowe');
    }
    public function testNegativeInput() {
        $this->assertEquals(0, Fib(-1));
    }
}
$suite = new PHPUnit_Framework_TestSuite(new Reflection_Class('FibonacciTest'));
PHPUnit_TextUI_TestRunner::run($suite);
?>
