<?php
require_once "PHPUnit/FrameWork/TestSuite.php";

class TestHarness extends PHPUnit_Framework_TestSuite {
  private $seen = array();
  public function __construct() {
    $this = parent::__construct();
    foreach( get_declared_classes() as $class) {
      $this->seen[$class] = 1;
    }
  }
  public function register($file) {
    require_once($file);
    foreach( get_declared_classes() as $class) {
      if(array_key_exists($class, $this->seen)) {
        continue;
      }
      $this->seen[$class] = 1;
      //  ZE zmienia litery na mae, wic szukamy "testcase"
      if(substr($class, -8, 8) == 'testcase') {
        print "dodawanie $class\n";
        $this->addTestSuite($class);
      }
    }
  }
}
?>
