<?php
require_once "Service.inc";
require_once "Console/Getopt.php";

class HTTP_ServiceCheck extends ServiceCheck
{
  public $url;
  public function __construct($params)
  {
    foreach($params as $k => $v) {
      $k = "$k";
      $this->$k = "$v";
    }
  }

  public function run()
  {
    if(is_resource(@fopen($this->url, "r"))) {
      return ServiceCheck::SUCCESS;
    }
    else {
      return ServiceCheck::FAILURE;
    }
  }
}

class EmailMe_ServiceLogger implements ServiceLogger {
  public function log_service_event(ServiceCheck $service)
  {
    if($service->current_status == ServiceChecker::FAILURE) {
      $message = "Problem z {$service->description()}\r\n";
      mail('oncall@example.com', 'Zdarzenie serwisowe', $message);
      if($service->consecutive_failures() > 5) {
        mail('oncall_backup@example.com', 'Zdarzenie serwisowe', $message);
      }
    }
  }

  public function log_current_status(ServiceCheck $service)
  {
    return;
  }
}

class Simple_ServiceLogger implements ServiceLogger {
  public function log_service_event(ServiceCheck $service)
  {
    fputs(STDERR, "ZDARZENIE: {$service->description()} {$service->url} {$service->current_status()}\n");
  }

  public function log_current_status(ServiceCheck $service)
  {
    fputs(STDERR, "STATUS: {$service->description()} {$service->current_status()}\n");
  }
}

class ErrorLog_ServiceLogger implements ServiceLogger {
  public function log_service_event(ServiceCheck $service)
  {
    if($service->current_status() !== $service->previous_status()) {
      if($service->current_status() === ServiceChecker::FAILURE) {
        $status = 'DOWN';
      }
      else {
        $status = 'UP';
      }
      error_log("{$service->description()} zmiana statusu na $status");
    }
  }

  public function log_current_status(ServiceCheck $service)
  {
    error_log("{$service->description()}: $status");
  }
}

function getOptions($default_opt, $shortoptions, $longoptions)
{
  require_once "Console/Getopt.php";
  $con = new Console_Getopt;
  $args = Console_Getopt::readPHPArgv();
  $ret = $con->getopt($args, $shortoptions, $longoptions);
  $opts = array();
  foreach($ret[0] as $arr) {
    $rhs = ($arr[1] !== null)?$arr[1]:true;
    if(array_key_exists($arr[0], $opts)) {
      if(is_array($opts[$arr[0]])) {
        $opts[$arr[0]][] = $rhs;
      } 
      else {
        $opts[$arr[0]] = array($opts[$arr[0]], $rhs);
      }
    }
    else { 
     $opts[$arr[0]] = $rhs;
    }
  }
  foreach ($default_opt as $k => $v) {
    if(!array_key_exists($k, $opts)) {
      $opts[$k] = $v;
    }
  }
  return $opts;
}

$shortoptions = "n:f:d";
$default_opts = array('n' => 5, 'f' => 'status.xml');
$args = getOptions($default_opts, $shortoptions, null);

$fp = fopen("/tmp/.lockfile", "a");
if(!$fp || !flock($fp, LOCK_EX | LOCK_NB)) {
  fputs($stderr, "Nieudane naoenie blokady\n");
  exit; 
}
if(!$args['d']) {
  if(pcntl_fork()) {
    exit;
  }
  posix_setsid();
  if(pcntl_fork()) {
    exit;
  }
}
fwrite($fp, getmypid());
fflush($fp);
  
$engine = new ServiceCheckRunner($args['f'], $args['n']);
$engine->loop();

/* vim: set ts=2 sts=2 expandtab bs=2 ai : */
?>
