<?php
require_once 'Smarty_ExampleOrg.php';  // Specjalizowana klasa Smarty

function create_table($params)
{
  if(!is_array($params['data'])) {
    return;
  }
  $retval = "<table>";
  foreach($params['data'] as $row) {
    $retval .= "<tr>";
    foreach($row as $col) {
      $retval .= "<td>$col</td>";
    }
    $retval .= "</tr>";
  }
  $retval .= "</table>";
  return $retval;
}

$smarty = new Smarty_ExampleOrg;
$smarty->register_function('create_table', 'create_table');
$data = array(array('filename', 'bytes'));
$files = scandir($smarty->template_dir);
foreach($files as $file) {
  $stat = stat("$smarty->template_dir/$file");
  $data[] = array($file, $stat['size']);
}

$smarty->assign('file_array', $data);
$smarty->display('list_templates.tpl');
?>