<?php
require_once "Net/Telnet.php";
class Cisco_RPC extends Net_Telnet {
  protected $password;
  function __construct($address, $password,$prompt=false) 
  {
    parent::__construct($address);
    $this->password = $password;
    $this->prompt = $prompt;
  }
  function login()
  {
    $response = $this->read_until("Password:");
    $this->_write($this->password);
    $response =  $this->read_until("$this->prompt>");
  }
  function __call($func, $var) {
    $func = str_replace("_", " ", $func);
    $func .= " ".implode(" ", $var);
    $this->_write($func);
    $response = $this->read_until("$this->prompt>");
    if($response === false || strstr($response, "%Unknown command")) {
      error_log("Niezaimplementowane polecenie Cisco: $func", E_USER_WARNING);
    } 
    else {
      return $response;
    }
  }
}

$router = new Cisco_RPC("10.0.0.1", "haslo");
$router->login();
print $router->show("ip route");

?>
