<?php
$zap = <<<SQL
DECLARE
zaw CLOB;
BEGIN
SELECT ZAWARTOSC into zaw
FROM test2_ins
WHERE nazwapliku='harrison_bergeron.txt';
:CLB:=zaw;
END;
SQL;
try {
    $dbh = oci_connect("test", "test", "localhost");
    if (!$dbh) {
        $err = oci_error();
        throw new exception($err['message']);
    }
    $lh = oci_new_descriptor($dbh, OCI_DTYPE_LOB);
    $res = oci_parse($dbh, $zap);
    oci_bind_by_name($res, ":CLB", $lh, -1, SQLT_CLOB);
    if (!oci_execute($res, OCI_NO_AUTO_COMMIT)) {
        $err = oci_error($dbh);
        throw new exception($err['message']);
    }
    $opowiadanie = $lh->read(65536);
    printf("Liczba znaków w tekście %d\n", strlen($opowiadanie));
}
catch(Exception $e) {
    print "Wyjątek:\n";
    die($e->getMessage() . "\n");
}
?>
