<?php
$ins = <<<SQL
insert into test2_ins(nazwapliku,zawartosc) values (:NAZWAPLIKU,empty_clob())
returning zawartosc into :CLB
SQL;
$zap = <<<SQL
select nazwapliku "Nazwa pliku",length(zawartosc) "Rozmiar pliku"
from test2_ins
SQL;
$nazwaPliku = "harrison_bergeron.txt";
try {
    $dbh = oci_connect("test", "test", "localhost");
    if (!$dbh) {
        $err = oci_error();
        throw new exception($err['message']);
    }
    $lob = oci_new_descriptor($dbh, OCI_DTYPE_LOB);
    $res = oci_parse($dbh, $ins);
    oci_bind_by_name($res, ":NAZWAPLIKU", $nazwaPliku, -1, SQLT_CHR);
    oci_bind_by_name($res, ":CLB", $lob, -1, SQLT_CLOB);
    if (!oci_execute($res, OCI_NO_AUTO_COMMIT)) {
        $err = oci_error($dbh);
        throw new exception($err['message']);
    }
    $lob->import("harrison_bergeron.txt");
    $lob->flush();
    oci_commit($dbh);
    $res = oci_parse($dbh, $zap);
    if (!oci_execute($res, OCI_NO_AUTO_COMMIT)) {
        $err = oci_error($dbh);
        throw new exception($err['message']);
    }
    $wiersz = oci_fetch_array($res, OCI_ASSOC);
    foreach ($wiersz as $klucz => $wartosc) {
        printf("%s = %s\n", $klucz, $wartosc);
    }
}
catch(Exception $e) {
    print "Wyjątek:\n";
    die($e->getMessage() . "\n");
}
?>
