<?php
error_reporting ( E_ALL );
require_once ('location.php');

class PodrozObliczenia {
    public static function obliczOdleglosc ($start, $cel) {
        $odleglosc = 0.0;
        
        //obliczenie odległości w linii prostej
        if ($cel->y == $start->y) {
            $odleglosc = $cel->x - $start->x;
        } else if ($cel->x == $start->x) {
            $odleglosc = $cel->y - $start->y;
        } else {       
            $odleglosc_y = $cel->y - $start->y;
            $odleglosc_x = $cel->x - $start->x;
            $odleglosc = sqrt ( ($odleglosc_x * $odleglosc_x) +
            ($odleglosc_y * $odleglosc_y) );
        }
        return $odleglosc;
    }
    
    public static function obliczKatWStopniach ($start, $cel) {
        //obliczenie wektora kierunku
        $odleglosc_y = $cel->y - $start->y;
        $odleglosc_x = $cel->x - $start->x;
        $kat = null; 
        
        if ($odleglosc_x) {
            if ($odleglosc_y) {
                $kat = atan($odleglosc_y / $odleglosc_x);
            } else {
                if ($odleglosc_x > 0) {
                    $kat = 0.0; //w prawo
                } else {
                    $kat = 180.0; //w lewo
                }
            }
        } else {
            if ($odleglosc_y) {
                if ($odleglosc_y < 0) {
                    $kat = - 90.0; //w dół
                } else {
                    $kat = 90.0; //w górę
                }
            }
        }
            
        return $kat;
    }

    public static function czyBliskoCelu($start, $cel, $krok){
        return (abs ( $start->x - $cel->x ) < $krok &&  abs ( $start->y - $cel->y ) < $krok );
    }
}
?>
