<?php
error_reporting(E_ALL);
require_once ('config.php');
require_once ('location.php');
require_once ('travelView.php');  
require_once ('travelMath.php');

class Podroz
{                       
    private $odleglosc = null;
    private $kat = 0.0;
    private $kat_w_radianach = 0.0;
    private $czas = 0.0;
    private $start = null;
    private $cel = null;
    
    public function __construct() {
        $this->odleglosc = new Lokalizacja(0, 0);
    }
    
    public function wykonaj(Lokalizacja $start, Lokalizacja $cel) {
        $this->start = $start;
        $this->cel = $cel;
        
        $this->obliczKatIOdleglosc();
        PodrozWidok::wyswietlPlanowanaTrase( $this->kat, $this->odleglosc, $this->start, $this->cel);
    
        if ($this->czyMamyOpcje()) {
            $this->wybierzNajlepszaOpcje();
        } else {
            $this->sprobujSpacerem();
        }
        PodrozWidok::wyswietlPodsumowanie($this->czas);
    }
    
    public function obliczKatIOdleglosc() {
        $this->kat = PodrozObliczenia::obliczKatWStopniach($this->start, $this->cel);
        $this->kat_w_radianach = deg2rad($this->kat);
        $this->odleglosc = PodrozObliczenia::obliczOdleglosc($this->start, $this->cel);
    }
    
    public function sprobujSpacerem() {
        if (ZLA_POGODA) {
            PodrozWidok::wyswietlBlad("Burza");
        } else if ($this->odleglosc < MAKSYMALNA_ODLEGLOSC_SPACERU) {
            $this->spacer ();
        } else {
            PodrozWidok::wyswietlBlad("Zbyt daleko na spacer");
        }
    }
    
    public function wybierzNajlepszaOpcje() {
        if (ZLA_POGODA) {
            $this->wybierzNajszybszyPojazd();
        } else {
            if ($this->odleglosc < MAKSYMALNA_ODLEGLOSC_SPACERU && !SPIESZYSZ_SIE) {
                $this->spacer();
            } else {
                $this->wybierzNajszybszyPojazd();
            }
        }
    }
    
    private function wybierzNajszybszyPojazd() {
        if (MASZ_SAMOCHOD) {
            $this->jazdaSamochodem();
        } else if (MASZ_PIENIADZE && NA_TRASIE_AUTOBUSU) {
            $this->jazdaAutobusem();
        } else {
            $this->jazdaRowerem();
        }
    }
    
    private function czyMamyOpcje(){
        $ma_opcje = false;
        if (MASZ_SAMOCHOD || (MASZ_PIENIADZE && NA_TRASIE_AUTOBUSU) || MASZ_ROWER) {
            $ma_opcje = true;
        }
        
        return $ma_opcje;
    }
        
    private function ruszaj($krok, $wiadomosc) {
        while (!PodrozObliczenia::czyBliskoCelu($this->start, $this->cel, $krok)) {
            $this->przejdzBlizejCelu($krok, $wiadomosc);
        }
        PodrozWidok::wyswietlZakonczenie($wiadomosc);
    }
    
    private function jazdaSamochodem() {
        $this->czas = OPOZNIENIE_SAMOCHODU;
        $this->ruszaj(KROK_SAMOCHOD, "Samochód");
    }
    
    private function jazdaAutobusem() {
        $this->czas = OPOZNIENIE_AUTOBUSU;
        $this->ruszaj(KROK_AUTOBUS, "Autobus");
    }
    
    private function jazdaRowerem() {
        $this->ruszaj(KROK_ROWER, "Rower");
    }
    
    private function spacer() {
        $this->ruszaj(KROK_SPACER, "Spacer");
    }
    
    private function przejdzBlizejCelu($krok, $metoda) {
        $this->start->x += ( $krok * cos($this->kat_w_radianach));
        $this->start->y += ( $krok * sin($this->kat_w_radianach));
        ++$this->czas;
        PodrozWidok::wyswietlStatusAktualnejLokalizacji($metoda, $this->start->x, $this->start->y);
    }
}
?>
