<?php
class SubObject
{
    static $instances = 0;
    public $instance;

    public function __construct() {
        $this->instance = ++self::$instances;
    }

    public function __clone() {
        $this->instance = ++self::$instances;
    }
}

class MyCloneable
{
    public $object1;
    public $object2;

    function __clone()
    {
        // Wymusz kopię this->object, w przeciwnym wypadku
        // zostanie skierowany na ten sam obiekt.
        $this->object1 = clone $this->object1;
    }
}

$obj = new MyCloneable();

$obj->object1 = new SubObject();
$obj->object2 = new SubObject();

$obj2 = clone $obj;


print("Oryginalny obiekt:\n");
print_r($obj);

print("Sklonowany obiekt:\n");
print_r($obj2);

?>