// Niniejsza funkcja przeksztaca cig tekstowy danych st do ich pierwotnej postaci
// Wynik zostaje zapisany w tym samym cigu tekstowym, ktry zosta przekazany do
// funkcji jako parametr jej wywoania.
void UrlDecode(char *st) {
  char *p=st;  // wskanik do aktualnie przetwarzanego znaku cigu
  char hex[3]; // bufor podrczny do przechowywania cigw typu %XX
  int code;    // zdekodowany znak
  // Pocztek ptli, ktra jest wykonywana do chwili osignicia kocowego znaku
  // cigu tekstowego (tj. do czasu pobrania znaku 0)
  do {
    // Jeli pobranym znakiem jest % ...
    if (*st=='%') { // jest on kopiowany do bufora podrcznego
      hex[0]=*(++st); hex[1]=*(++st); hex[2]=0;
      // Przeksztacenie cigu tekstowego do wartoci liczbowej
      sscanf(hex,"%X",&code);
      // i zapisanie znaku w wejciowym cigu tekstowym
      *p++(char)code;
      // Wskanik p zawsze wyznacza t pozycj w cigu tekstowym, na ktrej zapisywany
      // jest kolejny zdekodowany znak.
    }
    // W przeciwnym przypadku, jeli znakiem jest +, naley go zastpi znakiem spacji
    else if (*st=='+') *p++=' ';
    // Jeli jest to inny znak, zostaje on przepisany bez zmian
    else *p++=*st;
  } while (*st++!=0); // dopki nie zostanie pobrany znak 0
}
