<?if(!defined("LIBRARIAN_LOADED")) {
define("LIBRARIAN_LOADED",1);
// Domylne rozszerzenie plikw biblioteki
define("LibExt","phl");
// cieki wyszukiwania. Jeli rozpoczynaj si od kropki, wyszukiwanie
// ZAWSZE odbywa si od aktualnego katalogu, nawet jeli zostanie on zmieniony.
// W przeciwnym razie cieka zostanie zmieniona na ciek bezwzgldn
$INC[]=".";
$INC[]="./lib";
// czenie w pene cieki z komponentw $dir i $fname z jednoczesn
// poprawn obsug dodatkowych ukonikw (na przykad na kocu $dir lub
// pocztku $fname).
function glue_path($dir,$fname)
{ $dir=strtr(trim($dir),"\\","/");
  $fname=strtr(trim($fname),"\\","/");
  if(@$fname[0]=='/') return $fname;
  if(@$dir[strlen($dir)-1]=='/') return $dir.fname;
  return "$dir/$fname";
}
// Ta funkcja konwertuje wzgldne cieki na ich bezwzgldne odpowiedniki.
// Jeli cieka jest ju bezwzgldna (czyli prowadzi od korzenia systemu plikw),
// nic si nie dzieje. W przeciwnym przypadku aktualna nazwa katalogu (lub
// nazwa podana w $cur) zostaje wykorzystana w konwersji. Nie jest sprawdzane
// istnienie pliku w podanej lokalizacji. Funkcja jest wolna od pewnych niuansw
// zwizanych z wbudowan funkcj realpath() i posiada pewne dodatkowe moliwoci.
// Niestety jest nieco powolna.
function GetAbsPath($name,$cur="") { return abs_path($name,$cur); }
function abs_path($name,$cur="")
{ // konwersja lewych ukonikw na ukoniki
  $name=strtr(trim($name),"\\","/");
  // Rozbicie cieki wzgldem znaku "/"
  $Parts=explode("/",$name);
  $Path=($cur===""?getcwd():$cur);  // pocztkowy katalog wyszukiwania
  foreach($Parts as $i=>$s) if($s!=".") {
    // Czy jest to katalog gwny?
    if(!$i && (strlen($s)>1 && $s[1]==":"||$s=="")) $Path=$s;
    // Czy jest to odniesienie si do katalogu nadrzdnego
    else if($s=="..") {
      // Jeli to ju katalog gwny, gdzie si uda?
      if(strlen($Path)>1 && $Path[1]==":" && strlen($Path)<=3 || $Path=="/" || $Path=="\\") continue;
      // W przeciwnym razie uyj dirname()
      $p=dirname($Path);
      if($p=="/"||$p=="\\"||$p==".") $Path=""; else $Path=$p;
    }
    // w przeciwnym razie uyj nazwy nastpnego katalogu
    else if($s!=="") $Path=glue_path($Path,$s);
  }
  return ($Path!==""?$Path:"/");
}

// Konwertuje adres URL na ciek bezwzgldn
// Oznacza to, e jeli adres zaczyna si od ukonika, wynik traktowany jest
// jako cieka rozpoczynajca si od katalogu DOCUMENT_ROOT. W przeciwnym razie
// pocztkiem cieki jest aktualny katalog. Przedstawiona funkcja jest daleka
// od doskonaoci (na przykad nie obsuguje adresw URL okrelonych dyrektyw
// Alias z Apache, ale rzadko takie rozwizanie jest potrzebne).
function url2path($name)
{ $curUrl=dirname($GLOBALS["SCRIPT_NAME"]);
  $url=abs_path(trim($name),$curUrl);
  return getenv("DOCUMENT_ROOT").$url;
}

// Konwertuje wszystkie cieki z $INC na wersje bezwzgldne.
// Wykonuje to zadanie tylko wtedy, gdy tablica ulega zmianie od
// ostatniego wykonania.
function AbsolutizeINC()
{ global $INC;
  static $PrevINC=""; //warto $INC z poprzedniego wywoania
  // Najpierw wystpuje sprawdzenie, czy $INC ulego zmianie. Jeli tak,
  // dokonuje konwersji cieek z tablicy na wersje bezwzgldne. W przeciwnym
  // razie nic nie robi. W ten sposb zwiksza si wydajno funkcji.
  if($PrevINC!==$INC) {
    // Nie mona uy foreach, gdy zachodzi potrzeba modyfikacji tablicy
    for($i=0; $i<count($INC); $i++) {
      $v=&$INC[$i];
      if($v[0]=="." && (strlen($v)==1 || $v[1]=='\\' || $v[1]=='/')) continue;
      $v=abs_path($v);
    }
    // Zapamitanie aktualnego stanu tablicy
    $PrevINC=$INC;
  }
}

// Zaadowanie odpowiedniej biblioteki. W trakcie poszukiwania pliku sprawdzane
// s katalogi z tablicy $INC
function Uses($libname)
{ global $INC;
  static $PrevINC=""; // warto $INC z poprzedniego wywoania
  static $LastFound=0; // zwikszenie wydajnoci funkcji
  // Konwersja wszystkich cieek z $INC na wersje bezwzgldne na wypadek,
  // gdyby wywoujcy program doda jak ciek do tablicy.
  AbsolutizeINC();
  // Sprawdzenie cieek poczynajc od tej, gdzie ostatnio znaleziono bibliotek.
  // Prawdopodobnie kolejny modu take znajduje si w tym samym katalogu.
  // Jeli nie, naley sprawdzi ca list...
  $l=$LastFound;
  do {
    // Czy plik moduu znajduje si w poprzednim katalogu?
    $dir=$INC[$LastFound];
    if(@is_file($file="$dir/$libname.".LibExt)) {
      // Zmiana aktualnego katalogu na taki, w ktrym znajduje si modu
      $cwd=getcwd();
      chdir(dirname($file));
      // Zapewnienie, by wszystkie zmienne globalne byy dostpne w module
      foreach($GLOBALS as $k=>$v) global $$k;
      // doczenie pliku
      $ret=include_once($file);
      // Przed powrotem do poprzedniego katalogu, skonwertuj cieki na wersje
      // bezwzgldne.
      AbsolutizeINC();
      // Powrt
      chdir($cwd);
      return $ret;
    }
    $LastFound=($LastFound+1)%count($INC);
  } while($LastFound!=$l);
  // Zakoczenie programu w przypadku bdu
  die("Nie znaleziono pliku biblioteki \"$libname\" w ".join(", ",$inc)."!");
}

// Poprawienie niektrych zmiennych rodowiskowych, ktre mog zawiera bdne
// wartoci, jeli PHP nie dziaa jako modu Apache.
@putenv("SCRIPT_NAME=".
  $GLOBALS["HTTP_ENV_VARS"]["SCRIPT_NAME"]=
  $GLOBALS["SCRIPT_NAME"]=
  ereg_Replace("\\?.*","",getenv("QUERY_STRING"))
);
@putenv("SCRIPT_FILENAME=".
  $GLOBALS["HTTP_ENV_VARS"]["SCRIPT_FILENAME"]=
  $GLOBALS["SCRIPT_FILENAME"]=
  Url2Path(getenv("SCRIPT_NAME"))
);

// Wczenie maksymalnej kontroli bdw.
Error_Reporting(1+2+4+8);

// UWAGA! Po znaczniku zamykajcym NIE MOG POJAWI SI ADNE SPACJE. W przeciwnym
// razie zostan one wysane do przegldarki, co jest niedopuszczalne w przypadku
// korzystania z cookies.
}?>
