<?
// Zwraca pen ciek do pliku z tymczasowym schowkiem sesji
// Jeli musi zosta zmieniony katalog z sesjami,
// wystarczy tylko zmodyfikowa t funkcj
function ses_fname($key)
{
  return "sessiondata/".session_name()."/$key";
}
// Te funkcje nic nie robi, ale i tak trzeba bylo je zdefiniowa
function ses_open($save_path, $ses_name) { return true; }
function ses_close() { return true; }

// Odczyt danych z tymczasowego schowka
function ses_read($key)
{
  // Pobierz nazw pliku i otwrz go
  $fname=ses_fname($key);
  $f=@$fopen($fname,"rb"); if (!$f) return "";
  // Odczytaj plik a do jego koca
  $st=fread($f,filesize($fname));
  fclose($f);
  return $st;
}

// Zapis danych sesji do tymczasowego schowka
function ses_write($key, $val)
{
  $fname=ses_fname($key);
  // Po pierwsze utwrz katalogi (jeli ju istniej,
  // zignoruj bdy)
  @mkdir($d=dirname(dirname($fname)),0777);
  @mkdir(dirname($fname),0777);
  // Utwrz plik zapisz do niego dane sesji
  $f=@$fopen($fname,"wb"); if (!$f) return "";
  fwrite($f,$val);
  fclose($f);
  return true;
}

// Zniszczenie sesji
function ses_destroy($key)
{
  return @unlink(ses_fname($key));
}

// Czyszczenie - poszukiwanie starych plikw i ich usuwanie
function ses_gc(int $maxlifetime)
{
  $dir=ses_fname(".");
  // uzyskanie dostpu do katalogu aktualnej grupy
  $d=@opendir($dir); if (!$d0 return false;
  $DelDir=1; // Wskanik, e katalog jest pusty i moe zosta usunity
  // Odczytanie wszystkich elementw katalogu
  while(($e=readdir($d)!==false) {
    // Jeli to kropki, pomi je
    if ($e=="."||$e=="..") continue;
    // Plik jest zbyt stary
    if (time()-filemtime($fname="$dir/$e")>=$maxlifetime) {
      @unlink($fname);
      continue;
    }
    // Plik nie jest zbyt stary, wic katalog pozostanie
    $DelDir=0;
  }
  closedir($d);
  // Jeli wszystkie pliki byy stare i zostay usunite, usu take katalog
  if($DelDir) @rmdir($dir);
  return true;
}

// Rejestracja procedur obsugi
session_set_save_handler(
  "ses_open","ses_close",
  "ses_read","ses_write",
  "ses_destroy","ses_gc"
);

// Aby przetestowa przykad, stosujemy grup test
session_name("test");
session_start();
session_register("count");
// pozostay kod jak dawniej
$count=@$count+1;
?>
<body>
<h2>Licznik</h2>
W aktualnej sesji strona zostaa otwarta <?=$count?> razy. Zamknij przegldark, by zresetowa licznik.
</body>
