<?
// Jest to podobne do funkcji imageColorAllocate() (domylnie),
// ale korzysta z koloru w formacie XXYYZZ zamiast w formacie RGB.
// Oto opis formatu:
// * XX - komponent czerwieni w formacie szesnastkowym
// * YY - komponent zieleni w formacie szesnastkowym
// * ZZ - komponent niebieskiego w formacie szesnastkowym
// Jako parametr $func moe zosta podana inna funkcja zwracajca
// indeks koloru, na przykad imageColorClosest
function imageColorHex($im, $c, $func="imageColorAllocate")
{ // Po pierwsze dodaj zera na pocztku, jeli jest to konieczne
  for($i=strlen($c); $i<6; $i++) $c='0'.$c;
  $r=hexdec(substr($c,0,2));
  $g=hexdec(substr($c,2,2));
  $b=hexdec(substr($c,4,2));
  return $func($im,$r,$g,$b);
}

// Ustawienie wartoci domylnych. Parametry te mona podmieni,
// odpowiednio wywoujc skrypt, na przykad:
// ttf.php?a=20$f=arial&text=Witajcie
if(!@$a) $a=30;        // kt obrotu (domylnie 30)
if(!@$s) $s=80;        // rozmiar czcionki (80)
if(!@$b) $b="00AAAA";  // kolor ta (niebiesko-zielony)
if(!@$c) $c="FFFF00";  // kolor tekstu (jasny ty)
if(!@$d) $d=10;        // odstp midzy tekstem a granic obrazu
if(!@$f) $f="times";   // nazwa czcionki
if(!@$text) $text="Witaj PHP!"; // tekst do wypisania
// Pobranie granic tekstu
$Bnd=imageTTFBBox($s,$a,getcwd()."/$f.ttf",$text);
// Tablice ze wsprzdnymi x i y wszystkich punktw
$x=$y=array();
// Wypenienie tych tablic danymi z $Bnd
for($i=0;$i<4;$i++) {
  $X[]=$Bnd[$i*2];
  $Y[]=$Bnd[$i*2+1];
}
// Obliczenie rozmiaru obrazu z uwzgldnieniem parametru $d
$MX=max($X)-min($X)+$d*2; // rozmiar X
$MY=max($Y)-min($Y)+$d*2; // rozmiar Y
// Obliczenie wsprzdnych punktu bazowego tekstu,
// aby dobrze wyrodkowa tekst.
$x=$d+$Bnd[0]-min($X)+2;
$y=$d+$Bnd[1]-min($Y)+2;

// Utworzenie obrazu zgodnie w wyliczonymi danymi
$im = imageCreate($MX,$MY);
// Utworzenie nowych kolorw na palecie kolorw
$black = imageColorHex($im, 0);  // czer (cienie)
$back  = imageColorHex($im, $b);  // to
$front = imageColorHex($im, $c);  // litery

// Wyczyszczenie ta
imageFill($im,0,0,$back);
imageRectangle($im,0,0,$MX-1,$MY-1,$black);
// Utworzenie cienia
imagettftext($im,$s,$a,$x+2,$y+2,$black,getcwd()."/$f.ttf",$text);
// Narysowanie tekstu
imagettftext($im,$s,$a,$x,$y,$front,getcwd()."/$f.ttf",$text);

// Wysanie obrazu do przegldarki
Header("Content-type: image/png");
imagePng($im);
?>
