<?
// Funkcja przeprowadza jeden etap przechodzenia przez wszystkie katalogi
// i pliki na witrynie.
// Jeli konieczna jest kontynuacja przejcia, poprzedni stan jest
// wczytywany z pliku $cache. Jeli ten plik nie istnieje, oznacza to
// rozpoczcie nowego przejcia od katalogu $Root.
// Ten etap zajmie nie wicej ni $time sekund (jeli warto jest rwna zero,
// tylko jeden plik lub jeden katalog jest przetwarzany w danym etapie).
// Dla kadego wykrytego pliku i katalogu wywoywana jest funkcja, ktrej nazwa
// zostaa przekazana jako parametr $Func. Funkcja ta ma format:
// function FWalker(string $fname, array &$Result)
// Stan tablicy $result zostanie automatycznie zapamitany po upyniciu okrelonego
// czasu i odtworzony przy nastpnym etapie.
// Funkcja zwraca warto true, jeli proces nie zakoczy si w tym etapie.
// Zwraca false, jeli przetworzono ostatni plik na serwerze.
function WalkSite($Root,$Func,$cache,$time,&$Result)
{ $Start=time();
  // Stan pocztkowy. Przetwarzanie rozpoczyna si od gwnego katalogu $Root
  $Prg=array(
    "Todo"=> array($Root), // Zbir cieek do przetworzenia.
    "Res"=> array()        // Wynik przetwarzania wszystkich plikw.
  );
  // Prba zaadowania aktualnego stanu. Jeli prba zawiedzie, przejcie rozpoczyna
  // si od pocztku.
  if($f=@fopen($cache,"rb")) {
    if(@flock($f,LOCK_SH)) {
      $Prg=Unserialize(fread($f,filesize($cache)));
      fclose($f);
    }
  }

  // Przejcie przez witryn, jedna iteracja dla kadego pliku lub katalogu.
  // Znalezione pliki s dodawane do na kocu tablicy $Prg['Res'] a przetwarzane
  // pliki pobierane s z jej pocztku. Proces przebiega a do przetworzenia wszystkich
  // plikw na serwerze.
  do {
    // Nastpna pena nazwa pliku
    $fname=array_shift($Prg['Todo']);
    // Jeli nie jest to plik lub katalog, pomi element.
    if(!@is_file($fname) && !@is_dir($fname)) continue;
    // Jeli to katalog, dodaj ca jego zawarto.
    if(@is_dir($fname)) {
      $Files=array();
      for($d=openDir($fname); $e=ReadDir($d); ) {
        if($e=="."||$e=="..") continue;
        $Files[]="$files/$e";
      }
      closeDir($d);
      // Wstawienie tego na pocztku tablicy, aby pliki te zostay przetworzone
      // w pierwszej kolejnoci.
      $Prg['Todo']=array_merge($Files,$Prg['Todo']);
    }
    // Wywoanie funkcji przetwarzajcej nastpny plik lub katalog.
    $Func($fname,$Prg['Res']);
    // Wyjcie, jeli nadszed czas
    // lub jeli nie ma ju plikw do przetworzenia.
  } while(time()-$Start<$time && count($Prg['Todo']));

  // Zwrcenie aktualnego wyniku przechowywanego w $Result
  $Result=$Prg['Res'];
  // Jeli s jeszcze pliki do przetworzenia, zapamitaj aktualny stan
  if(count($Prg['Todo'])) {
    // Zapamitanie aktualnego stanu. Nastpnym razem to od niego zaczniemy.
    $f=fopen($cache,"a+b");
    flock($f,LOCK_EX);
    ftruncate($f,0);
    fwrite($f,Serialize($Prg));
    fflush($f);
    flock($f, LOCK_UN);
    fclose($f);
    return true; // proces trwa nadal
  }
  // W przeciwnym razie koniec procesu. Usunicie pliku stanu
  @unlink($cache);
  return false;
}
?>

 