<?
// MysqlTable - dziaa przezroczycie z tabel bazy danych MySQL
// Klasa ta na og stanowi klas bazow dla innych klas (na przykad
// dla klasy Guestbook), wtedy odpowiednie funkcje s po prostu przysaniane.
// Pole przechowujce serializowane dane (niewidoczne z zewntrz).
define("DataField","__data__");
// ************************** Funkcje pomocnicze ********************************
// Jeli zmienna jest pusta, zainicjalizuj j
function Def0(&$st,$def) { if(!isSet($st)||$st=="") $st=$def; }
// Przygotowuje cig znakw danych binarnych przed dodaniem go do tabeli.
function Apostrophs(&$st)
{ $st=str_replace(chr(0),"\\0",$st);
  $st=str_replace("\\\\","\\\\",$st);
  $st=str_replace("'","\\'",$st);
  return $st;
}
// Pakowanie obiektu, konwersja go do cigu znakw
function SqlPack(&$obj)
{ $s=Serialize(&$obj); return Apostrophs($s); }
// Rozpakowanie cigu znakw i utworzenie obiektu
function SqlUnpack(&$st) { return Unserialize(&$st); }
// ******************************************************************************
// *** Poniej znajduje si opis klasy tabeli. Poza polami okrelonymi w
// konstruktorze, kady rekord tabeli bdzie zawiera dwa pola: id (unikatowy
// identyfikator rekordu) i __data__ (spakowana tablica wszystkich pozostaych
// pl). Poza podanymi polami do tabeli mona wstawia take inne pola. Zostan
// one zapamitane, ale nie bdzie mona na nich przeprowadza wyszukiwania.
// Wynika to z faktu serializacji tych pl w momencie dodawania lub aktualizacji i
// ich rozpakowania po pobraniu danych.
class MysqlTable {
// *** Zmienne wewntrzne
var $TableName;  // nazwa tabeli
var $UniqVars;   // lista unikatowych pl (nazwa=1, nazwa=1...)
var $Index;      // indeksy wykonane dla tych pl (nazwa=1, nazwa=1...)
var $Fields;     // wszystkie fizyczne pola tabeli (nazwa=typ, nazwa=typ...)
var $Error;      // tekst ostatniego bdu ("", jeli nie ma adnego)
var $justCreated; // rwne 1, jeli tabela wanie zostaa utworzona a nie zaadowana
// *** Funkcje wewntrzne
// Spakuj pola tablicy do cigu znakw poza tymi polami, ktre znajduj
// si w bazie danych.
function _PackFields(&$Hash)
{ $Data=array();
  foreach($Hash as $k=>$v) if($k!=DataField)
  if(!isSet($this->Fields[$k])) $Data[$k]=$v;
  return Serialize($Data);
}
// Funkcja wirtualna podklasy wywoywana PRZED kadym wstawieniem danych do tabeli,
// czyli przed kad aktualizacj lub dodaniem. Zadaniem funkcji jest
// "przezroczyste" i automatyczne wygenerowanie pewnych pl rekordu (na przykad
// czasu modyfikacji) przed jego zapisaniem.
// Na przykad moliwe jest przechowywanie daty w tabeli w formacie STM, ale udawanie
// e jest przechowywana w typowym formacie DD.MM.YYYY.
// Jeli funkcja zwrci warto 0, operacja zostanie przerwana a bd zapisany.
function PreModify(&$Rec) { return 1; }
// Funkcja wirtualna wywoywana PO pobraniu rekordu z tabeli a przed jego
// przekazaniem dalej. Innymi suy ona do "przezroczystej" modyfikacji rekordu
// tabeli, ktry wanie zosta otrzymany.
// Wracajc do poprzedniego przykadu. Po pobraniu danych z tabeli konwertujemy pole
// STM do formatu DD.MM.YYYY i nikt niczego nie zauway.
function PostSelect(&$Rec) { return; }
// Zwraca nazw tabeli.
function GetTableName() { return $this->TableName; }
// Zwraca wynik zapytania. Jednak ten wynik (jego deskryptor) na og bdzie
// przetwarzany przez funkcj GetResult().
// $Expr to wyraenie uywane w trakcie zapytania.
// $Order to kierunek srtowania, domylnie sortowanie malejce po polu id).
function TableSelectQuery($Expr="",$Order="id desc")
{ $this->Error="";
  if(!$Expr) $Expr="1=1";
  $r=mysql_query("select * from ".$this->TableName.
  " where ($Expr) and (id>1) order by $Order");
  if(!$r) { $this->Error=mysql_error(); return; }
  return $r;
}
function SelectQuery($Expr="",$Order="id desc")
{ return $this->TableSelectQuery($Expr,$Order); }
// Zwraca wyniki poprzedniego zapytania "select" (a dokadniej nastpny znaleziony
// wynik jako rozpakowan(!) tablic. Jeli SelectQuery() znalazo kilka
// rekordw, odczyta si je kolejnymi wywoaniami funkcji GetResult().
// Metoda zajmuje si rozpakowaniem danych. Co wicej, jeli wynik jest
// wielowierszowy, metoda zwraca nastpny wiersz. Gdy wiersze zostan wyczerpane
// zwraca warto "".
// Na og ta funkcja (a take funkcja SelectQuery()) nie jest potrzebna, gdy
// metoda Select() pozwala od razu zwrci jako tablic wszystkie wyniki zapytania.
function TableGetResult($r)
{ $this->Error="";
  // Pobierz nastpny wiersz jako tablic
  if(!$r) $Result=mysql_fetch_array($r);
    else $this->Error=mysql_error();
  if(!@is_array($Result)) return;
  // Przejd przez wszystkie pola tabeli i zapisz je w tablicy $Hash
  $Hash=array();
  foreach($this->Fields as $k=>$v)
    if(isSet($Result[$k])) $Hash[$k]=$Result[$k];
  $Hash+=SqlUnpack($Hash[DataField]); unSet($Hash[DataField]);
  $this->PostSelect($Hash);
  // To wszystko
  return $Hash;
}
function GetResult($r) { return $this->TableGetResult($r); }
// Uwaga: uywam dwch funkcji (GetResult to synonim funkcji TableGetResult), aby
// umoliwi podklasie wywoania oryginalnych funkcji nawet wtedy, gdy zostan one
// przysonite. Niestety jest to jedyny sposb uzyskania tego zadania w PHP.
// Podobna kwestia dotyczy funkcji mysql_num_rows()

function DataSeek($r,$to) { return mysql_data_seek($r,$to); }
// Tworzy lub wczytuje tabel $Name
// $Fields to lista pl w bazie danych. S to pola wykorzystywane pniej przy
// wyszukiwaniu i indeksowaniu. Poza nimi mona do rekordu tabeli doda dowoln inn
// zmienn, ale bd one szeregowane i dopiero pniej zapisywane.
// Format listy jest nastpujcy: tablica, ktrej klucze to nazwy zmiennych a wartoci
// to ich typy. Jeli $Fields nie jest tablic, zakada si, i tablica jest
// otwierana w oryginalnym formacie. W przeciwnym razie dokonuje si sprawdzenia
// czy ktrej pola lub indeksy zostay dodane lub usunite. Jeli tak, na tabeli
// przeprowadza si odpowiednie modyfikacje (jest to bardzo dugi proces)
// OSTRZEENIE: jeli istnieje pole tabeli, ktre jest serializowane, NIE STANIE
// si ono automatycznie polem nonym, gdy zostanie dodane do $Fields.
// Innymi sowy zostanie stracone (odwrotne stwierdzenie take jest prawdziwe).
// ZALECENIA: jako $Fields naley przekaza tylko te pola, ktre NA PEWNO s
// w bazie danych a take te pola, ktre bd uywane przy wyszukiwaniu, indeksacji
// i pobieraniu unikatowych wartoci.
// $Index okrela pola uywane do tworzenia indeksu.
// Indeksy zwikszaj rozmiar bazy danych, ale przyspieszaj wyszukiwanie, jeli
// dotyczy indeksowanych pl). Klucze s nazwami kolumn a wartoci to rozmiary
// indeksu (domylnie 0, co w wikszoci przypadkw jest odpowiedni wartoci).
function MysqlTable($Name,$Fields="",$Index="")
{ $this->TableName=$Name; $this->Error="";
  if(is_array($Fields)) {
    foreach($Fields as $k=>$v)
      if(!eregi("not null",$v)) $Fields[$k]=$v." not null";
      $Fields=array("id"=>"int auto_increment primary key")
        +$Fields+array(DataField=>"mediumblob");
  }
  Def0($Index,array());
  // Odczytanie pl tabeli wraz z ich parametrami
  $this->Fields=array(DataField=>"mediumblob");
  $Data=$this->TableGetResult(
    mysql_query("select ".DataField." from $Name where id=1")
  );
  // Jeli tabela istnieje, zapytanie jest poprawne
  // W takim przypadku trzeba sprawdzi, czy tabela zmienia si od ostatniego razu.
  // Jeli tak, powinna zosta poprawiona.
  if(@is_array($Data)) {
    if(!is_array($Fields)) {
      $this->Error="Nie mog utworzy tabeli: nie podano adnych pl";
      return;
    }
    Def0($Data["Fields"],array());
    Def0($Data["Index"],array());
    // ** Prawdopodobnie co ulego zmianie. Wykonaj polecenie "alter table".
    // 1. Dodano pewne pola.
    $Lst=array();
    foreach($Fields as $k=>$v) {
      if(!isSet($Data["Fields"][$k])) $Lst[]="add $k $v";
        else if ($Data["Fields"][$k]!=$v) $Lst[]="change $k $k $v";
    }
    // 2. Usunito pewne pola
    foreach($Data["Fields"] as $k=>$v)
      if(!isSet($Fields[$k])) $Lst[]="drop $k";
    // 3. Dodano pewne indeksy
    foreach($Index as $k=>$v) if(!isset($Data["index"][$k]))
      $Lst[]="add index index_$k ($k".($v!=0?" ($v)":"").")";
    // 4. Usunito pewne indeksy
    foreach($Data["Index"] as $k=>$v)
      if(!isSet($Index[$k])) $Lst[]="drop index index_$k";
    if(count($Lst)) {
      PrintDump($Lst);
      if(!mysql_query("alter table $Name ".implode($Lst,","))) {
        $this->Error=mysql_error();
        return;
      }
      $Changed=1;
    }
    $this->JustCreated=0;
  } else {
    // Tabela musi zosta utworzona.
    // Trzeba ponownie zresetowa zmienn Error, gdy inaczej zawieraaby
    // informacj o bdzie z poprzedniego zapytania
    $this->Error="";
    $Lst=array();
    foreach($Fields as $k=>$v) $Lst[]="$k $v";
    foreach($Index as $k=>$v)
      $Lst[]="index index_$k ($k".($v!=0?" ($v)":"").")";
    if(!mysql_query("create table $Name (".implode($Lst,",").")")) {
      $this->Error=mysql_error();
      return;
    }
    $this->JustCreated=1;
  }
  // Zapisz informacj o tabeli, jeli ulega zmianie
  if(!empty($Changed)||$this->JustCreated) {
    $Data["Fields"]=$Fields;
    $Data["Index"]=$Index;
    Def0($Data["Info"],array()); // Nie byo informacji, wic tabela jest pusta
    $Data=SqlPacj($Data);
    if($this->JustCreated) {
      $Result=mysql_query("insert into $Name(id,".DataField.
        ") values(1, '$Data')");
    } else {
      $Result=mysql_query("update $Name set ".DataField.
        "='$Data' where id=1");
    }
    if(!Result) { $this->Error=mysql_error(); return; }
  }
  $this->Fields=$Fields;
  $this->Index=$Index;
}

// Zapisuje oglne informacje o tabeli. Informacje te mona pobra TYLKO
// metod GetInfo(). Jeli na przykad tabela jest uywana jako
// ksiga goci, mona w tym miejscu zapia pewne informacje o ksidze,
// na przykad nazw waciciela i haso. $Inf moe by dowolnego typu
// na przykad tablic.
function TableSetInfo($Inf)
{ $this->Error="";
  // Odczytanie rekordu informacyjnego
  $r=mysql_query("select ".DataField." from ".
    $this->TableName." where id=1");
  if(!($Data=$this->GetResult($r))) return;
  // Ustawienie pola Info
  $Data["Info"]=$Inf;
  $Data=SqlPack($Data);
  // Zapisanie wyniku
  if(!mysql_query("update ".$this->TableName.
    " set ".DataField."='$Data' where id=1"))
  { $this->Error=mysql_error(); return; }
  return 1;
}
function SetInfo($Inf) { return $this->TableSetInfo(&$Inf); }
// Zwraca informacje o tabeli ustawione wczeniej metod SetInfo.
// Jeli informacje nie byy wczeniej zapisane, zwraca pust tablic.
function TableGetInfo()
{ $this->Error="";
  // Odczytuje rekord informacyjny
  $r=mysql_query("select * from ".$this->TableName." where id=1");
  // Jeli co poszo nie tak, GetResult ustawi pole Error obiektu.
  if(!($Data=$this->GetResult($r))) return array();
  if(!@is_array($Data["Info"])) $Data["Info"]=array();
  return $Data["Info"];
}
function GetInfo() { return $this->TableSetInfo(); }
// Usunicie tabeli. Uwaga! Tabela jest niszczona bez adnego ostrzeenia!
function TableDrop()
{ $this->Error="";
  if(mysql_query("drop table ".$this->TableName)) {
    $this->Error=mysql_error();
    return 0;
  }
  return 1;
}
function Drop() { return $this->TableDrop(); }
// Dodaje do tabeli rekord $Rec (na og jest to tablica asocjacyjna z polami).
// Jej id jest ustawiany automatycznie a dodatkowo sprawdzane jest, czy pola
// okrelone jako unikatowe w konstruktorze s rzeczywicie unikatowe.
// Zwraca 1 w przypadku powodzenia, $Rec zawiera ostateczn posta rekordu
function TableAdd(&$Rec)
{ $this->Error="";
  if(!$this->PreModify($Rec)) return 0;
  // Wszystko inne jest poprawne. Dodaj rekord.
  $Rec[DataField]=$this->_PackFields($Rec);
  // Utwrz listy nazw i wartoci pl
  $LNames=$LVals=array();
  foreach($this->Fields as $name=>$type) {
    $LNames[]=$name;
    $LVals[]="'".Apostrophs($Rec[$name])."'";
  }
  $LNames=implode($LNames,",");
  $LVals=implode($LValrs,",");
  unSet ($Rec[DataField]);
  // Dodanie
  if(!mysql_query("insert into ".$this->TableName.
    "($LNames) values ($LVals)"))
  { $this->Error=mysql_error(); return 0; }
  $Rec["id"]=mysql_insert_id();
  $this->PostSelect($Rec);
  return 1;
}
function Add(&$Rec) { return $this->TableAdd(&$Rec); }

// Usunicie z tabeli rekordw, ktre s zgodne z wyraeniem $Expr
// Na przykad: $Tbl->Delete("(id=$id) or (id=0)");
function TableDelete($Expr)
{ $this->Error="";
  if(!mysql_query("delete from ".$this->TableName.
    " where ($Expr) and (id>1)"))
  { $this->Error=mysql_error(); return 0; }
  return 1;
}
function Delete($Expr) { return $this->TableDelete($Expr); }

// Zwraca tablic rekordw (klucz to identyfikator, warto to rekord)
// Tablica bdzie zawieraa nie wicej ni $Num rekordw. Dla kadego
// rekordu wywoywana jest metoda PostSelect()!
function TableSelect($Expr="",$Num=100000,$Order="id desc")
{ $this->Error="";
  // Przeprowadzenie zapytania
  $r=$This->SelectQuery($Expr,$Order); if(!$r) return 0;
  // Przejcie przez znalezione rekordy
  for($i=0, $Found=array(); $i<$Num&&($Rec=$this->GetResult($r)); $i++)
    $Found[$Rec["id"]]=$Rec;
  return $Found;
}
function Select($Expr="",$Num=100000,$Order="id desc")
{ return $this->TableSelect($Expr,$Num,$Order); }
// Aktualizuje rekord w tabeli. Zmienia si rekord $Upd i przyjmuje on tak posta,
// jak bdzie mia po aktualizacji. Innymi sowy mona doda nowe pola. Jeli nie
// istnieje rekord o podanym identyfikatorze, generowany jest bd (jeli nie
// poda si parametru $id, jego warto zostanie pobrana z $Upd["id"])!
// W pewnych sytuacjach w $Upd nie znajduje si warto identyfikatora, na przykad
// zdarza si to w danych formularzy. W takiej sytuacji identyfikator podaje si
// jako drugi parametr $id.
// Identyfikator NIE ZMIENIA SI przy aktualizacji (w odrnieniu od dodawania, kiedy
// to identyfikator jest ustawiany)!
function TableUpdate(&$Upd,$id=0)
{ $this->Error="";
  // Jeli podano $id, jest to identyfikator rekordu.
  if($id) $Upd["id"]=$id;
  // Zaaduj starszy rekord. Moe by tylko jeden.
  $r=$this->SelectQuery("id=".$Upd["id"]);
  $Rec=$this->GetResult($r);
  // Jeli wczytywanie zawiodo, aktualizacja nie moe zosta przeprowadzona,
  // gdy rekord nie istnieje.
  if(!$Rec) { $this->Error="NotExists"; return 0; }
  // W przeciwnym razie wszystko jest w porzdku - dodaj rekord
  // Najpierw uaktualnij pola i spakuj zmienne
  $Rec=$Upd+$Rec; $Upd=$Rec;
  if(!$this->PreModify($Rec)) return 0;
  $Rec[DataField]=$this->_PackFields($Rec);
  // Wykonaj list pl do aktualizacji
  $Lst=array();
  foreach($this->Fields as $name=>$type)
    $Lst[]="$name='".Apostrophs($Rec[$name])."'";
  $Lst=implode($Lst,",");
  // Przeprowadzenie zapytania
  if(!mysql_query("update ".$this->TableName.
    " set $Lst where id=".$Rec["id"]))
  { $this->Error=mysql_error(); return 0; }
  $this->PostSelect($Rec);
  return 1;
}
function Update(&$Upd,$id=0) { return $this->TableDelete(&$Upd,$id); }
// Zwraca liczb rekordw zgodnych z wyraeniem $Expr. Jeli wyraenie nie zostanie
// podane, zwracana jest CZNA liczba rekordw.
function TableGetCount($Expr="")
{ $this->Error="";
  if(!$Expr) $Expr="1=1";
  $r=mysql_query("select count(if(($Expr) and (id>1),1,NULL)) from ".
    $this->TableName);
  if(!$r) { $this->Error=mysql_error(); return 0; }
  $a=mysql_fetch_array($r);
  return $a[0];
}
function GetCount($Expr="") { return $this->TableGetColumn($Expr); }
// Zwraca LIST wszystkich unikatowych wartoci pola $field w tabeli, ktrych rekordy
// speniaj wyraenie $Expr.
// OSTRZEENIE: funkcja dziaa tylko wtedy, gdy pole $field jest jednym z pl
// bezporednio zapamitywanych w bazie danych (zostao przekazane w $Fields).
// W przeciwnym razie zostaje wygenerowany bd.
// Zaleca si utworzenie rekordu indeksu dla takiego pola.
function TableGetDistinct($field,$Expr="")
{ $this->Error="";
  if(!$Expr) $Expr="1=1";
  $r=mysql_query("select distinct $field from ".
    $this->TableName. " where ($Expr) and (id>1)");
  // "distinct" nie dziaa z fraz "order by". Powody nie s mi znane...
  if(!$r) { $this->Error=mysql_error(); return 0; }
  for($Arr=array(),$i=0,$n=mysql_num_rows($r);$i<$n;$i++)
    $Arr[]=mysql_result($r,$i,0);
  return $Arr;
}
function GetDistinct($field,$Expr="")
{ return $this->TableGetDistinct($field,$Expr); }
}; // koniec klasy
?>

