<?
// Stae okrelajce pewne wartoci domylne
define("DefGlue"," | ");             // domylny znak czcy zawartoci blokw
define("Htaccess_Name",".htaccess"); // nazwa pliku .htaccess

// Nazwy standardowych blokw
define("BlkTemplate","template");    // strona szablonu
define("BlkOutput","output");        // wyjcie do przegldarki
define("BlkDefGlue","defaultglue");  // domylny znak czcy

// Wykorzystywane zmienne
$GLOBALS["BLOCK"]=array();        // tablica z zawartoci wszystkich blokw
$GLOBALS["BLOCK_INC"]=array();    // podobna do tablicy $INC bibliotekarza
$GLOBALS["CURBLOCK_URL"]=false;   // adres URL aktualnie analizowanego pliku
$GLOBALS["bSingleLine"]=0;        // czy analizowany plik to .htaccess?

// W poniszej tabeli wymienione s nazwy funkcji filtrujcych. Funkcje s
// wywoywane dla kadego bloku, ktrego zawarto wanie pobrano. Mona
// doda wicej filtrw (na przykad te dziaajce jako prosty
// makroprocesor zamieniajcy pewne znaczniki innymi). Format funkcji filtru
// jest nastpujcy:
// void FunFiltru(string $NazBloku, string &$Wartosc, string $UrlBloku)
$GLOBALS["BLOCKFILTERS"]=array(
  "_FBlkTabs",
  "_FBlkGlue"
  // tutaj mona umieci nazwy wasnych funkcji filtrujcych
);
// Zwraca ciao bloku zgodnie z jego nazw
// Wielko liter jest ignorowana
function BLK($name)
{ return @$GLOBALS["BLOCK"][strtolower($name)];
}

// Dodaje podany adres URL do listy cieek wyszukiwania, cieka jest
// automatycznie konwertowana na wersj bezwzgldn (aktualny katalog
// jest tym, w ktrym znajduje si aktualnie przetwarzany plik)
function Inc($url)
{ global $CURBLOCK_URL,$SCRIPT_NAME;
  $CurUrl=$CURBLOCK_URL; if(!$CurUrl) $CurUrl=$SCRIPT_NAME;
  if($url[0]!="/") $url=abs_path($url,dirname($CurUrl));
  $GLOBALS["BLOCK_INC"][]=$url;
}

// Ustawia nazw aktualnego bloku i prawdopodobnie jego warto.
// Cae wyjcie danych po wykonaniu wywoania tej funkcji naley do
// ciaa bloku $name. Jeli podano parametr $value, ciao jest od razu
// ustawianie na $value a pozostae wyjcie ignorowane. Jest to wygodne
// rozwizanie dla blokw jednowierszowych, w szczeglnoci tych znajdujcych
// si w pliku .htaccess. Pocztkowe i kocowe spacje zostan usunite z
// wyjcia programu. Zostan take wywoane funkcje filtrujce. Koniec bloku
// stanowi albo koniec pliku, albo pocztek innego bloku (kolejne wywoanie
// funkcji Block()).
function Block($name=false, $value=false)
{ global $BLOCK,$bSingleLine,$CURBLOCK_URL;
  // Zdefiniowanie niektrych znacznikw
  static $Handled=false;  // czy wystpuje przechwytywanie wyjcia
  static $CurBlock=false; // nazwa aktualnie przetwarzanego bloku
  // Jeli podano nazw bloku, zmie j na mae litery
  if ($name!==false) $name=strtolower(trim($name));
  // Wyjcie zostao przechwycone. Oznacza to, i funkcja Block() zostaa
  // wywoana ju wczeniej. Blok analizowany przez wczeniejsze wywoanie
  // wanie si zakoczy, wic musi zosta dodany do tablicy blokw
  // lub te naley zignorowa wyjcie.
  if($Handled) {
    // Czy podano nazw poprzedniego bloku?
    if($CurBlock!==false) {
      // Dodanie do tablicy blokw.
      $BLOCK[$CurBlock]=trim(ob_get_contents());
      // Jeli blok jest jednowierszowy (z pliku .htaccess),
      // usu wszystkie wiersze poza pierwszym.
      if(@$bSingleLine)
        $BLOCK[$CurBlock]=ereg_Replace("[\r\n].*","",$BLOCK[$CurBlock]);
      // wywoanie filtrw
      _ProcessContent($CurBlock,$BLOCK[$CurBlock],$CURBLOCK_URL);
    }
    // Zakocz przechwytywanie strumienia wyjciowego
    ob_end_clean(); $Handled=0;
  }

  // Jeli podano nazw bloku (zdecydowana wikszo przypadkw), funkcja
  // zostaa wywoana w celu inicjalizacji nowego bloku a nie tylko
  // zakoczenia poprzedniego (patrz funkcja Load()).
  if($name!==false) {
    // Przechwytywanie wyjcia
    ob_start(); $Handled=1;
    // Ciao nie jest jawnie okrelone, wic musi zosta pobrane dziki
    // przechwytywaniu wyjcia. Informujemy system, i aktualny blok to
    // $name i e powinien pobiera dane z wyjcia a do momentu natrafienia
    // na inny blok lub koniec pliku
    if($value===false) {
      $CurBlock=$name;
    } else {
      // Ciao zostao jawnie okrelone. Zapisz blok do tablicy.
      // Wcz przechwytywanie wyjcia, aby je pniej zignorowa.
      _ProcessContent($name,$value,$CURBLOCK_URL);
      $BLOCK[$name]=$value;
      $CurBlock=false;
    }
  }
}

// Wczytanie pliku o adresie $name i dodanie blokw w nim zawartych do listy blokw.
// Parametr $name moe by cieka wzgldn. Jeli tak, jest poszukiwany w
// ciekach znajdujcych si w globalnej tablicy $INC (uywanej przez bibliotekarza).
// Jeli $name to katalog a nie plik, przeanalizowany zostaje plik .htaccess z
// tego katalogu. W momencie wczytywania pliku aktualny katalog zmieniany jest na
// ten, w ktrym znajduje si dany plik.
function Load($name)
{ global $BLOCK,$bSingleLine,$CURBLOCK_URL, $BLOCK_INC;
  // Konwersja wszystkich cieek w $INC do formatu bezwzgldnego
  AbsolutizeINC();
  // Jeli cieka jest wzgldna, poszukaj jej, korzystajc z $BLOCK_INC
  $fname=false;
  if($name[0]!='/') {
    // Przejcie przez wszystkie katalogi z doczeniami
    foreach($BLOCK_INC as $v) {
      $fname=Url2Path("$v/$name");  // okrelenie nazwy pliku
      if(file_exists($fname)) { $name="$v/$name"; break; }
    }
    // Jeli niczego nie znaleziono, $fname pozostaje rwne false
  } else {
    // Adres URL jest bezwzgldny, wic skonwertuj go na nazw pliku.
    $fname=Url2Path($name);
  }
  // Przetwrz plik, ktrego nazwa zostaa pobrana z adresu URL
  // Najpierw sprawd, czy plik istnieje.
  if($fname===false || !file_exists($fname))
    die("Nie potrafi otworzy \"$name\"!");
  // Jest to katalog, wic uyj .htaccess
  $Single=false;
  if(@is_dir($fname)) {
    $name.=glue_patn($name, Htaccess_Name);
    $fname.=glue_patn($fname, Htaccess_Name);
    $Single=1;
  }
  // Jeli plik nadal nie istnieje (moe si tak zdarzy, gdy brakuje pliku
  // .htaccess w danym katalogu, cicho opu funkcj. Brak pliku .htaccess w
  // katalogu nie jest sytuacj alarmow.
  if(!file_exists($fname)) return;
  // Uruchom plik. Jednak najpierw zapamitaj aktualny stan i katalog.
  // Nastpnie zaaduj bloki pliku (wykonaj plik). Pniej odtwrz stan.
  $PrevSingle=$bSingleLine; $bSingleLine=@$Single;
  $SaveDir=getcwd(); chdir(dirname($fname));
  $SaveCBU=$CURBLOCK_URL; $CURBLOCK_URL=$name;
  // Pocztkowe spacje i pewne inne niechciane znaki mog wystpowa w pliku
  // (na przykad moe to by znak komentarza w pliku .htaccess).
  // Wszystkie one zostaj doczone w specjalnym bloku _PreBlockText.
  // Z tego bloku nie naley korzysta.
  Block("_PreBlockText");
  // Udostpnienie wszystkich zmiennych globalnych.
  foreach($GLOBALS as $k=>$v) if(!@Isset($$k)) global $$k;
  // Doczenie pliku
  include $fname;
  // Zasygnalizuj, e blok si skoczy (osignito koniec pliku). Gdy tak
  // si stanie, dane z ostatniego bloku pliku s na og zapisywane do tablicy.
  Block();
  if(@$php_errormsg && ereg("^parse",$pgp_errormsg))
    echo "<b>Ostrzeenie:</b> $php_errormsg w $fname, ".
      "wiersz ??? - dzikujemy twrcom PHP <nobr>:-(</nobr>";
  chdir($SaveDir);
  $CURBLOCK_URL=$SaveURL;
  $bSingleLine=$PrevSingle;
}

// Gwna funkcja zarzdcy szablonw. Przetwarza plik $url i zwraca ciao
// bloku Output. Nic nie jest wysyane na wyjcie (poza komunikatami o bdach,
// jeli wystpiy).
function RunUrl($url)
{ global $BLOCK;
  // Zbierz wszystkie bloki
  _CollectBlocks($url);
  // Znajd i rozpocznij gwny szablon. Zadanie to wykonuje si na kocu,
  // by szablon mg skorzysta z wszystkich blokw zwizanych ze stron.
  // Szablon jest typowym plikiem z blokami. Musi jednak zawiera blok Output.
  $tmpl=@$BLOCK[BlkTemplate];
  if(!$tmpl) {
    die("Nie potrafi znale szablonu dla <b>$url</b> ".
      "(czy zosta zdefiniowany blok <tt>".BlkTemplate."</tt>?)");
  }
  Load($tmpl);
  // Zwrcenie bloku wyjciowego
  if(!Isset($BLOCK[BlkOutput])) {
    die("Brak wyjcia z szablonu <b>$tmpl</b> ".
      "(czy zosta zdefiniowany blok <tt>".BlkOutput."</tt>?)");
  }
  return $BLOCK[BlkOutput];
}

// Funkcja tylko do uytku wewntrznego. Zbiera bloki z pliku o podanym $url,
// wczajc w to bloki z wszystkich plikw .htaccess katalogw nadrzednych.
function _CollectBlocks($url)
{ global $BLOCK;
  $url=abs_path($url,dirname($GLOBALS["SCRIPT_NAME"]));
  // Jeli ciek nie jest "/", zajrzyj do katalogu nadrzdnego.
  if(strlen($url)>1) _CollectBlocks(dirname($url));
  // Zaadowanie blokw pliku.
  Load($url);
}
// Wywoanie wszystkich filtrw dla bloku
function _ProcessContent($name,&$cont,$url)
{ foreach($GLOBALS["$BLOCKFILTERS"] as $F)
    $F($name,$cont,$url);
}

// czenie blokw
// Jeli ciao bloku zaczyna si od [nazwa], zostaje doczone do wartoci bloku
// ju znajdujcej si w tablicy. W tym procesie do czenia uywa si ciaa
// bloku podanego jako parametr nazwa. Jeli nazwa nie zostaa podana (puste
// nawiasy kwadratowe), uywany jest blok DefaultGlue. Jeli go take brakuje,
// stosowany jest znak "|".
function _FBlkGlue($name,&$cont,$P)) {
  if(ereg("^\\[([^]])*]",$cont,$P)) {
    $c=substr($cont,strlen($P[0]));  // blok po [nazwa]
    $n=$P[1];   // nazwa cznika
    // Czy jest co do dodania?
    if(!empty($BLOCK[$name])) {
      $glue=@$BLOCK[$n];
      if(!Isset($glue)) $glue=@$BLOCK[BlkDefGlue];
      if(!Isset($glue)) $glue=DefGlue;
      $cont=$BLOCK[$name].$glue.$c;
    }
    // Nie ma nic do poczenia, wic tylko przypisz
    else $cont=$c;
  }
}

// Usunicie pocztkowych znakw tabulacji z ciaa bloku.
// Teraz dowolny kod HTML w dokumencie moe zosta wcity
// za pomoc znakw tabulacji. Jest to bardzo pomocne
// jeli na przykad korzysta si ze znacznikw w podany niej sposb.
// < ?foreach($Book as $k=>$v) {? >
//   <tr>
//     <td>< ?=$Book['name']? ></td>
//     <td>< ?=$Book['text']? ></td>
//   </tr>
// < ?}? >
function _FBlkTabs($name,&$cont,$url)
{ $cont=preg_replace("/^\t+/m","",$cont);
}
?>

