class pc_Web_Abuse_Check {
  var $sem_key;
  var $shm_key;
  var $shm_size;
  var $recalc_seconds;
  var $pageview_threshold;
  var $sem;
  var $shm;
  var $data;
  var $exclude;
  var $block_message;

  function pc_Web_Abuse_Check() {
    $this->sem_key = 5000;
    $this->shm_key = 5001;
    $this->shm_size = 16000;
    $this->recalc_seconds = 60;
    $this->pageview_threshold = 30;

    $this->exclude['/niesprawdzana.html'] = 1;
    $this->block_message =<<<END
<html>
<head><title>403 Dostp zabroniony</title></head>
<body>
<h1>Dostp zabroniony</h1>
dania pochodzce z tego komputera zostay odrzucone ze wzgldu 
na powtarzajce si prby zakcenia pracy witryny.
Jeli uwaasz, e jest to nieporozumienie prosimy o kontakt
<a href="mailto:administrator@przyklad.com?subject=Naduycie">administrator@przyklad.com</a>.
</body>
</html>
END;
   }
  
  function get_lock() {
    $this->sem = sem_get($this->sem_key,1,0600);
    if (sem_acquire($this->sem)) {
      $this->shm = shm_attach($this->shm_key,$this->shm_size,0600);
      $this->data = shm_get_var($this->shm,'data');
    } else {
      error_log("Nie mona pobra wartoci semafora $this->sem_key");
    }
  }

  function release_lock() {
    if (isset($this->data)) {
      shm_put_var($this->shm,'data',$this->data);
    }
    shm_detach($this->shm);
    sem_release($this->sem);
  }

  function check_abuse($user) {
    $this->get_lock();
    if ($this->data['abusive_users'][$user]) {
      // jeli uytkownik znajduje si na licie zwolnij semafor i pami
      $this->release_lock();
      //  wygeneruj stron informujc o odrzuceniu uytkownika
      header('HTTP/1.0 403 Forbidden');
      print $this->block_message;
      return true;
    } else {
     // zarejestrowanie uytkownika przegldajcego stron
     $now = time();
     if (! $this->exclude[$_SERVER['PHP_SELF']]) {
       $this->data['user_traffic'][$user]++;
     }
     // uaktualnienie listy nieobsugiwanych uytkownikw 
     if (! $this->data['traffic_start']) {
       $this->data['traffic_start'] = $now;
     } else {
       if (($now - $this->data['traffic_start']) > $this->recalc_seconds) {
         while (list($k,$v) = each($this->data['user_traffic'])) {
           if ($v > $this->pageview_threshold) {
             $this->data['abusive_users'][$k] = $v;
             // zapisanie w dzienniku faktu dodania nowego uytkownika do listy
             error_log("Naduycie: [$k] (z ".$_SERVER['REMOTE_ADDR'].')');
           }
         }
         $this->data['traffic_start'] = $now;
         $this->data['user_traffic'] = array();
       }
     }
     $this->release_lock();
    }
    return false;
  }
}
