require 'HTTP/Request.php';

function pc_link_extractor($s) {
    $a = array();
    if (preg_match_all('/<A\s+.*?HREF=[\"\']?([^\"\' >]*)[\"\']?[^>]*>(.*?)<\/A>/i',
                       $s,$matches,PREG_SET_ORDER)) {
        foreach($matches as $match) {
            array_push($a,array($match[1],$match[2]));
        }
    }
    return $a;
}

$url = $_SERVER['argv'][1];

// pobieranie stron za pomoc ptli - uwzgldnienie informacji o przekierowaniu 
$done = 0;
while (! $done) {
    $req = new HTTP_Request($url);
    $req->sendRequest();
    if ($response_code = $req->getResponseCode()) {
        if ((intval($response_code/100) == 3) &&
            ($location = $req->getResponseHeader('Location'))) {
            $url = $location;
        } else {
            $done = 1;
        }
    } else {
        return false;
    }
}

// ustalenie bazowego adresu url
// program nie uwzgldnia wartoci znacznika <base> zamieszczanego na stronie 
$base_url = preg_replace('{^(.*/)([^/]*)$}','\\1',$req->_url->getURL());

// przechowanie informacji o sprawdzonych odsyaczach, aby nie wystpi przypadek powtrnego odwoania do tego samego adresu
$seen_links = array();

if ($body = $req->getResponseBody()) {
    $links = pc_link_extractor($body);
    foreach ($links as $link) {
        // skip https URLs
        if (preg_match('{^https://}',$link[0])) {
            continue;
        }
        // zamiana adresw wzgldnych na bezwzgldne
        if (! (preg_match('{^(http|mailto):}',$link[0]))) {
            $link[0] = $base_url.$link[0];
        }
        // pominicie odsyacza, ktry by wczeniej analizowany
        if ($seen_links[$link[0]]) {
            continue;
        } 
        
        // oznaczenie odsyacza jako sprawdzonego
        $seen_links[$link[0]] = true;

        // wywietlenie informacji o sprawdzanym odsyaczu
        print $link[0].': ';
        flush();
        
        // sprawdzenie odsyacza
        $req2 = new HTTP_Request($link[0],
                                 array('method' => HTTP_REQUEST_METHOD_HEAD));
        $now = time();
        $req2->sendRequest();
        $response_code = $req2->getResponseCode();
        
        //jeli pobranie zakoczyo si pomylnie
        if ($response_code == 200) {
            // pobranie nagwka Last-Modified
            if ($lm = $req2->getResponseHeader('Last-Modified')) {
                $lm_utc = strtotime($lm);
            } else {
                // lub ustawienie wartoci Last-Modified zgodnie z aktualnym czasem
                $lm_utc = $now;
            }
            print strftime('%c',$lm_utc);
        } else {
            // jeli nie mona pobra strony, wywietlony zostanie kod odpowiedzi
            print $response_code;
        }
        print "\n";
    }
}

