function pc_indexed_links($total,$offset,$per_page) {
    $separator = ' | ';
    
    // wywietlenie odsyacza "<<Wstecz" 
    pc_print_link($offset == 1, '&lt;&lt;Wstecz', $offset - $per_page);


    // wywietlenie wszystkich zakresw rekordw oprcz ostatniego
    for ($start = 1, $end = $per_page;
         $end < $total;
         $start += $per_page, $end += $per_page) {

        print $separator;
        pc_print_link($offset == $start, "$start-$end", $start);
    }

    /* wywietlenie ostatniego zakresu rekordw -
     * na tym etapie $start wskazuje pierwszy element 
     * ostatniej grupy rekordw
     */
    
    /* tekst odsyacza powinien reprezentowa zakres rekordw tylko w przypadku
     * gdy na stronie mona wywietli wicej ni jeden element. Na przykad
     * wywietlajc 11 elementw po 5 elementw na stronie, ostatni odsyacz powinien
     * mie warto "11", a nie "11-11"
     */
    $end = ($total > $start) ? "-$total" : '';

    print $separator;
    pc_print_link($offset == $start, "$start$end", $start);
    
    // wywietlenie odsyacza "Dalej>>"
    print $separator;
    pc_print_link($offset == $start, 'Dalej&gt;&gt;',$offset + $per_page);
}
