function_exists('curl_exec') or die('brak rozszerzenia CURL');

function pc_link_extractor($s) {
    $a = array();
    if (preg_match_all('/<A\s+.*?HREF=[\"\']?([^\"\' >]*)[\"\']?[^>]*>(.*?)<\/A>/i',
                       $s,$matches,PREG_SET_ORDER)) {
        foreach($matches as $match) {
            array_push($a,array($match[1],$match[2]));
        }
    }
    return $a;
}

$url = $_SERVER['argv'][1];

// pobranie strony o okrelonym adresie URL
$c = curl_init($url);
curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($c, CURLOPT_FOLLOWLOCATION,1);
$page = curl_exec($c);
$info = curl_getinfo($c);
curl_close($c);

// ustalenie bazowego adresu url
// program nie uwzgldnia wartoci znacznika <base> zamieszczanego na stronie
$url_parts = parse_url($info['url']);
if ('' == $url_parts['path']) { $url_parts['path'] = '/'; }
$base_path = preg_replace('<^(.*/)([^/]*)$>','\\1',$url_parts['path']);
$base_url = sprintf('%s://%s%s%s',
                    $url_parts['scheme'],
                    ($url_parts['username'] || $url_parts['password']) ?
                    "$url_parts[username]:$url_parts[password]@" : '',
                    $url_parts['host'],
                    $url_parts['path']);

// przechowanie informacji o sprawdzonych odsyaczach, aby nie wystpi przypadek powtrnego odwoania do tego samego adresu
$seen_links = array();

if ($page) {
    $links = pc_link_extractor($page);
    foreach ($links as $link) {
        // zamiana adresw wzgldnych na bezwzgldne
        if (! (preg_match('{^(http|https|mailto):}',$link[0]))) {
            $link[0] = $base_url.$link[0];
        }
        // pominicie odsyacza, ktry by wczeniej analizowany
        if ($seen_links[$link[0]]) {
            continue;
        } 
        
        // oznaczenie odsyacza jako sprawdzonego
        $seen_links[$link[0]] = true;

        // wywietlenie informacji o sprawdzanym odsyaczu
        print $link[0].': ';
        flush();
        
        // sprawdzenie odsyacza
        $c = curl_init($link[0]);
        curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($c, CURLOPT_NOBODY, 1);
        curl_setopt($c, CURLOPT_HEADER, 1);
        $link_headers = curl_exec($c);
        $curl_info = curl_getinfo($c);
        curl_close($c);

        switch (intval($curl_info['http_code']/100)) {
        case 2:
            // odpowied o kodzie 2xx oznacza, e odsyacz jest poprawny
            $status = 'OK';
            break;
        case 3:
            // odpowied o kodzie 3xx oznacz przeniesienie strony w inne miejsce
            $status = 'Przeniesiono';
            if (preg_match('/^Location: (.*)$/m',$link_headers,$matches)) {
                $location = trim($matches[1]);
                $status .= ": $location";
            }
            break;
        default:
            // inne kody odpowiedzi odpowiadaj bdnym odsyaczom
            $status = "ERROR: $curl_info[http_code]";
            break;
        }

        print "$status\n";
    }
}
