function pc_html2ascii($s) {
  // konwersja odsyaczy
  $s = preg_replace('/<a\s+.*?href="?([^\" >]*)"?[^>]*>(.*?)<\/a>/i',
                    '$2 ($1)', $s);

  // przeksztacenie  znacznikw <br>, <hr>, <p>, <div> w znaki koca linii
  $s = preg_replace('@<(b|h)r[^>]*>@i',"\n",$s);
  $s = preg_replace('@<p[^>]*>@i',"\n\n",$s);
  $s = preg_replace('@<div[^>]*>(.*)</div>@i',"\n".'$1'."\n",$s);
  
  // konwersja tekstu pogrubionego i pochylonego
  $s = preg_replace('@<b[^>]*>(.*?)</b>@i','*$1*',$s);
  $s = preg_replace('@<i[^>]*>(.*?)</i>@i','/$1/',$s);

  // dekodowanie elementw HTML okrelonych nazwami
  $s = strtr($s,array_flip(get_html_translation_table(HTML_ENTITIES)));

  // dekodowanie elementw okrelonych cyframi
  $s = preg_replace('//e','chr(\\1)',$s);
  
  // usunicie pozostaych znacznikw
  $s = strip_tags($s);
  
  return $s;
}
