require 'DB.php';

// funkcja przydatna podczas uruchamiania programu - zapis bedw bazy danych
function log_die($ob) { print '<pre>'; print_r($ob); print '</pre>'; }

// poczenie z baz danych
$dbh = DB::connect('mysql://test:@localhost/test') or die("Nie mona ustanowi poczenia");
if (DB::isError($dbh)) { log_die($dbh); }
$dbh->setFetchMode(DB_FETCHMODE_OBJECT);
PEAR::setErrorHandling(PEAR_ERROR_CALLBACK,'log_die');

// Od warto $_REQUEST['cmd'] zaley dalszy przebieg programu
switch ($_REQUEST['cmd']) {
case 'read':                      // odczyt konkretnej wiadomoci
     pc_message_read();
     break;
case 'post':                      // wywietlenie formularza do przesyania wiadomoci
     pc_message_post();
     break;
case 'save':                      // zapis nowej wiadomoci
     if (pc_message_validate()) { // jeli wiadomo jest poprawna,
         pc_message_save();       // naley j zapisa
         pc_message_list();       // i wywietli list wiadomoci
     } else {
         pc_message_post();       // w przeciwnym razie, ponownie wywietlany jest formularz
     }
     break;
case 'list':                      // wywietlanie listy wiadomoci (domylne)
default:
     pc_message_list();
     break;
}

// pc_message_save() zapisuje wiadomo w bazie danych
function pc_message_save() {
    global $dbh;

    $parent_id = intval($_REQUEST['parent_id']);

    /* Polecenia MySQL majce na celu zapewnienie, e pc_message nie zmieni wartoci
     * podczas operowania ni. Konieczne jest take zblokowanie tabel, ktre
     * przechowuj wartoci pc_message i thread_seq
     */
    $dbh->query('LOCK TABLES pc_message WRITE, thread_seq WRITE, pc_message_seq WRITE');

    // czy wiadomo jest odpowiedzi na inny list?
    if ($parent_id) {

        // pobranie informacji o wtku, poziomie i pozycji w wtku (thread_pos) wiadomoci nadrzdnej 
        $parent = $dbh->getRow("SELECT thread_id,level,thread_pos
                                FROM pc_message 
                                WHERE id = $parent_id");

        // warto poziomu odpowiedzi jest o jeden wiksza od poziomu wiadomoci nadrzdnej 
        $level = $parent->level + 1;

        /* jaka jest najwysza warto thread_pos we wszystkich wiadomociach 
           wywodzcych si od jednej wiadomoci nadrzdnej? */
        $thread_pos = $dbh->getOne("SELECT MAX(thread_pos) FROM pc_message 
            WHERE thread_id = $parent->thread_id AND parent_id = $parent_id");

        // czy s ju jakie odpowiedzi na ten list?
        if ($thread_pos) {
            // warto thread_pos jest o jeden wysza od dotychczas najwyszej
            $thread_pos++;
        } else {
            // jest to pierwsza odpowied, naley j umieci zaraz za wiadomoci nadrzdn 
            $thread_pos = $parent->thread_pos + 1;
        }

        /* zwikszenie thread_pos we wszystkich wiadomociach wtku wystpujcych 
           po tej wiadomoci */
        $dbh->query("UPDATE pc_message SET thread_pos = thread_pos + 1 
            WHERE thread_id = $parent->thread_id AND thread_pos >= $thread_pos");

        // nowa wiadomo musi zasta zapisana z identyfikatorem wiadomoci nadrzdnej 
        $thread_id = $parent->thread_id;
    } else {
        // wiadomo nie jest odpowiedzi, zaczyna wic nowy wtek 
        $thread_id = $dbh->nextId('thread');
        $level = 0;
        $thread_pos = 0;
    }
    
    // pobranie nowego identyfikatora dla wiadomoci 
    $id = $dbh->nextId('pc_message');

    /* dodanie wiadomoci do bazy danych. Zastosowanie prepare() i execute() zapewnia
       waciwe otoczenie wartoci pl znakami apostrofu */
    $prh = 
        $dbh->prepare("INSERT INTO pc_message (id,thread_id,parent_id,
                       thread_pos,posted_on,level,author,subject,body) 
                       VALUES (?,?,?,?,NOW(),?,?,?,?)");

    $dbh->execute($prh,array($id,$thread_id,$parent_id,$thread_pos,$level,
                             $_REQUEST['author'],$_REQUEST['subject'],
                             $_REQUEST['body']));


    // Zwolnienie blokady tabeli pc_message.
    $dbh->query('UNLOCK TABLES');
}

// pc_message_list() wywietla list wszystkich wiadomoci
function pc_message_list() {
    global $dbh;

    print '<h2>Lista wiadomoci</h2><p>';

    /* uoenie wiadomoci zgodnie z wartoci identyfikatora wtku (thread_id) oraz
       wedug pozycji w wtku (thread_pos) */
    $sth = $dbh->query("SELECT id,author,subject,LENGTH(body) AS body_length,
                       posted_on,level FROM pc_message
                       ORDER BY thread_id,thread_pos");
    while ($row = $sth->fetchRow()) {
        // wcinanie wiadomoci poziomu wyszego ni 0
        print str_repeat('&nbsp;',4 * $row->level);
        // wywietlenie informacji o wiadomoci wraz z odsyaczem do niej
        print<<<_HTML_
<a href="$_SERVER[PHP_SELF]?cmd=read&id=$row->id">$row->subject</a> autor: 
$row->author @ $row->posted_on ($row->body_length bajtw)
<br>
_HTML_;
    }

    // umoliwienie przesania wiadomoci niebdcej odpowiedzi
    printf('<hr><a href="%s?cmd=post">Rozpocznij nowy wtek</a>',
           $_SERVER['PHP_SELF']);
}

// pc_message_read() wywietla wskazan wiadomo
function pc_message_read() {
    global $dbh;
    
    /* naley si upewni, e przekazany identyfikator wiadomoci jest liczb
       cakowit i rzeczywicie reprezentuje wiadomo */
    $id = intval($_REQUEST['id']) or die("Niewaciwy identyfikator wiadomoci");
    if (! ($msg = $dbh->getRow(
        "SELECT author,subject,body,posted_on FROM pc_message WHERE id = $id"))) {
        die("Niewaciwy identyfikator wiadomoci");
    }

    /* wprowadzony przez uytkownika kod HTML nie jest 
       do wywietlania nowych linii stosowane s znaczniki HTML */
    $body = nl2br(strip_tags($msg->body));

    // wywietlenie wiadomoci z odsyaczami odpowiedzi i powrotu na list wiadomoci
    print<<<_HTML_
<h2>$msg->subject</h2>
<h3>autor: $msg->author</h3>
<p>
$body
<hr>
<a href="$_SERVER[PHP_SELF]?cmd=post&parent_id=$id">Odpowiedz</a>
<br>
<a href="$_SERVER[PHP_SELF]?cmd=list">Lista wiadomoci</a>
_HTML_;
}

// pc_message_post() wywietla formularz do przesyania wiadomoci
function pc_message_post() {
    global $dbh,$form_errors;
    
    foreach (array('author','subject','body') as $field) {
        // obsuga znakw specjalnych w wartociach domylnych pl
        $$field = htmlspecialchars($_REQUEST[$field]);
        // wywietlanie komunikatw o bdach w kolorze czerwonym
        if ($form_errors[$field]) {
            $form_errors[$field] = '<font color="red">' . 
                $form_errors[$field] . '</font><br>';
        }
    }

    // czy ta wiadomo jest odpowiedzi na inny list?
    if ($parent_id = intval($_REQUEST['parent_id'])) {

        // przy odsyaniu formularza warto parent_id rwnie musi by doczona
        $parent_field = 
            sprintf('<input type="hidden" name="parent_id" value="%d">',
                    $parent_id);

        // jeeli nie podano tematu, naley uy tematu wiadomoci nadrzdnej
        if (! $subject) {
            $parent_subject = $dbh->getOne('SELECT subject FROM pc_message
                                        WHERE id = ?',array($parent_id));
            /* dodanie prefiksu 'Odp: ' do tematu wiadomoci nadrzdnej, chyba, e
               prefiks ten ju si znajduje w temacie */
            $subject = htmlspecialchars($parent_subject);
            if ($parent_subject && (! preg_match('/^odp:/i',$parent_subject))) {
                $subject = "Odp: $subject";
            }
        }
    }

    // wywietlenie formularza z komunikatami o bdach i wartociami domylnymi
    print<<<_HTML_
<form method="post" action="$_SERVER[PHP_SELF]">
<table>
<tr>
 <td>Nazwisko:</td>
 <td>$form_errors[author]<input type="text" name="author" value="$author">
</td>
<tr>
 <td>Temat:</td>
 <td>$form_errors[subject]<input type="text" name="subject" value="$subject">
</td>
<tr>
 <td>Wiadomo:</td>
 <td>$form_errors[body]<textarea rows="4" cols="30" wrap="physical" 
name="body">$body</textarea>
</td>
<tr><td colspan="2"><input type="submit" value="Przelij wiadomo"></td></tr>
</table>
$parent_field
<input type="hidden" name="cmd" value="Zapisz">
</form>

_HTML_;
}

// pc_message_validate() sprawdza czy kade z pl zawiera jakkolwiek warto
function pc_message_validate() {
    global $form_errors;

    $form_errors = array();

    if (! $_REQUEST['author']) {
        $form_errors['author'] = 'Prosz poda nazwisko.';
    }
    if (! $_REQUEST['subject']) {
        $form_errors['subject'] = 'Prosz okreli temat wiadomoci.';
    }
    if (! $_REQUEST['body']) {
        $form_errors['body'] = 'Prosz wpisa tre wiadomoci.';
    }

    if (count($form_errors)) {
        return false;
    } else {
        return true;
    }
}
