<?php

//    header("Content-type: image/png");
    header("Expires: Sun, 11 Aug 2002 05:00:00 GMT");
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");  
    header("Cache-Control: no-store, no-cache, must-revalidate");  
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");

    // Parametry obrazka

    $cel_zbiorki = 1000; // Kwota docelowa w euro
    $krok = 200; // Wielko jednego stopnia na skali w euro

    $obrazek_szerokosc = 100;
    $obrazek_wysokosc = 200;

    $x = 60; // pozioma pozycja termometru w pikselach
     // ("rodek zbiorniczka")
    $y = 170; // pionowa pozycja termometru w pikselach
     // ("rodek zbiorniczka ")

    $wysokosc = 340; // wysoko termometru w pikselach, liczona od rodka zbiorniczka do grnego zakoczenia rurki 
    $szerokosc = 30; // szeroko termometru w pikselach
    $kreska = 20; // Dugo kreski w pikselach

    // Dugo skali w pikseach (Koniec skali znajduje si w odlegoci 1.5 * szeroko termometru poniej grnego koca termometru)
    $skala = $wysokosc - 1.5 * $szerokosc;
    // pionowa pozycja kreski, pokazujcej kwot docelow (koniec skali)
    $max = $y - $skala;
    // piksel na euro:
    $pne = $skala / $cel_zbiorki;
    // piksel na krok:
    $pnk = $krok * $pne;
    // pionowa pozycja, gdzie prosta cz rurki termometru przechodzi w zaokrglenie 
    $koniec_rurki = $y - $wysokosc + 0.5 * $szerokosc;


    // Przygotowujemy obrazek
    $obrazek = @ImageCreate($obrazek_szerokosc, $obrazek_wysokosc)
     or die("Bd podczas prby inicjalizacji GD Image Stream");
    $tlo_kolor = ImageColorAllocate ($obrazek, 255, 255, 255);
    $tekst_kolor = ImageColorAllocate ($obrazek, 0, 0, 102);
    $obrazek_kolor = ImageColorAllocate ($obrazek, 0, 0, 204);
    $wypelnienie_kolor = ImageColorAllocate ($obrazek, 204, 0, 51);


    // "Zbiorniczek":
    ImageArc($obrazek, $x, $y,
    1.5 * $szerokosc + 1,
    1.5 * $szerokosc + 1,
    0, 360,
    $obrazek_kolor);
    // Wypeniamy zbiorniczek
    ImageFill($obrazek, $x, $y, $wypelnienie_kolor);
    // ... i otwieramy na grze
    ImageArc($obrazek, $x, $y,
    1.5 * $szerokosc + 1,
    1.5 * $szerokosc + 1,
    230, 310,
    $wypelnienie_kolor);


    // Rysujemy rurk
    ImageLine($obrazek,
        $x - $szerokosc/2, $y - $szerokosc/2,
        $x - $szerokosc/2, $koniec_rurki,
        $obrazek_kolor);
    ImageLine($obrazek,
        $x + $szerokosc/2, $y - $szerokosc/2,
        $x + $szerokosc/2, $koniec_rurki,
        $obrazek_kolor);
    ImageArc($obrazek, $x, $koniec_rurki,
       $szerokosc, $szerokosc,
       180, 0, $obrazek_kolor);


    // Skala 

    $sy = $y;
    $euro = 0;

    while ($sy > $max) {
        $sy = $sy - $pnk;
                $euro = $euro + $krok;
        ImageLine($obrazek,
              $x - $szerokosc/2, $sy,
              $x - $szerokosc/2 - $kreska, $sy,
              $obrazek_kolor);
        ImageString($obrazek,
                    3, $x - $szerokosc - $kreska, $sy,
                    $euro, $tekst_kolor);

    }

    // Pobieramy informacje o datkach
    include("./datki_klasy.phpi");
    $lista_datkow = new lista_datkow;
    $razem = $lista_datkow->suma();


    // wyliczamy poziom
    $poziom = $y - $pne * $razem;

    // Rysujemy poziom

   ImageLine($obrazek,
          $x - $szerokosc/2, $poziom,
          $x + $szerokosc/2, $poziom,
          $wypelnienie_kolor);
    // Wypeniamy rurk do wyznaczonego poziomu
    ImageFill($obrazek, $x, $poziom + 1, $wypelnienie_kolor);


    ImagePng($orazek);

 ?>
