<?php

   // Skrypt sprawdzajcy, czy przegldarka przesaa dane wejciowe. Jeli nie, wywietlany jest formularz do skadania datku. W przeciwnym razie dane z formularza zostan sprawdzone i wywietlone w potwierdzeniu dla uytkownika. W przypadku niepoprawnych danych wywietlana jest wypeniona wersja formularza.

    if (sizeof($_POST) == 0) {
        $kwota = 50; // proponowana wysoko darowizny
        include("formularz_datek_wypelniony_rozszerzony.php");
        exit(); // Zakocz skrypt!
    }


    $hack = false;  // ta zmienna typu boolean wskazuje, czy nie mamy do czynienia z dziaaniem hakera

    // Czytanie danych z $_POST

    $imiedarczyncy = $_POST["imiedarczyncy"];
    $adres = $_POST["adres"];
    $kwota = $_POST["kwota"];
    $kk_rodzaj = $_POST["kk_rodzaj"];
    $kk_numer = $_POST["kk_numer"];
    $kk_data = $_POST["kk_data"];
    $publiczny = $_POST["publiczny"];
    $godzina = $_POST["godzina"];

    // Weryfikacja danych
// $imiedarczyncy moe by dowolnym cigiem znakw
// nie moe by tylko cigiem pustym
    if ($imiedarczyncy == "") {
        $hack = true; $pole = "Imi i nazwisko";
    }
    //$adres moe by rwnie dowolnym niepustym cigiem znakw
    if ($adres == "") {
        $hack = true; $pole = "Adres";
    }
    // Kwota musi by liczb cakowit pomidzy 5 a 100 
    if (!preg_match("/^\d*[05]$/", $kwota)) { // nie jest liczb cakowit?
        $hack = true; $pole = "kwota";
    }
    if (($kwota < 5) || ($kwota > 100)) {
        $hack = true; $pole = "Kwota";
    }
    // Akceptowane karty to Visa, Mastercard, American Express
    switch ($kk_rodzaj) {
        case "Visa": break;
        case "Mastercard": break;
        case "American Express": break;
        default:
            $hack = true; $pole = "kk_rodzaj";
    }
    // Numer karty powinien skada si z czterech grup, 
// z ktrych kada powinna skada si z 4 cyfr
// Ktra powinny by poczone spacj, cznikiem lub napisane w jednym cigu:
    if (!preg_match("/^(\d{4}[\s\-]?){4}$/", $kk_numer)) {
        $hack = true; $pole = "kartannumer";
    }
    // Termin wanoci karty powinien skada si z 4 cyfr,
// przy czym pierwsze dwie powinny lee w przedziale od 1 do 12
// a trzecia musi rwna si 0 (chyba e termin wanoci karty
// upywa po roku 2009
// Czwarta cyfra musi lee pomidzy 2 a 9
    if (!preg_match("/^(\d{2})0[2-9]$/", $kk_data, $match)) {
        $hack = true; $pole = "Termin wanoci karty";
    }
    else
    {
        if (($match[1] < 1) || ($match[1] > 12)) {
            $hack = true; $pole = "Termin wanoci karty";
        }
    }
    // Pole wyboru  moe by albo puste, 'on' lub zhakowane. 
    if (($publiczny != "") && ($publiczny != "on")) {
        $hack = true; $pole = "Upublicznienie danych";
    }
    // Czas wypenienia formularza musi by liczb cakowit
    if (!preg_match("/^\d+$/", $godzina)) {
        $hack = true; $pole = "godzina";
    }
     // Czy zaczono zdjcie?
     if ($_FILES["zdjeciedarczyncy"]["size"] > 0) {
         $zdjecie = true;
         preg_match("/(\.\w+)$/",
             $_FILES["zdjeciedarczyncy"]["name"],$match);
         $typ = $match[1];
         // akceptujemy tylko rozszerzenia plikw graficznych 
         if (in_array(
                 strtolower($typ),
                 array(".gif",".bmp",".jpg",".png",".jpeg"))) {
             $nazwapliku = uniqid("").$typ;
             $sciezka =
                 preg_replace("/\/[^\/]+$/","",
                              $_SERVER["SCRIPT_FILENAME"])
                              ."/obrazki/";
             copy($_FILES["zdjeciedarczyncy"]["tmp_name"],
                  $sciezka.$nazwapliku);
         }
     }
     else
     {
        $zdjecie = false;
     }

    // W przypadku nieprawidowych danych wywietl komunikat o bdzie:
    if ($hack) {
        include("formularz_datek_wypelniony_rozszerzony.php");
        exit(); // Zakocz skrypt!
    }

    // w tym miejscu pniej dodamy kod, ktry zapisuje dane w bazie danych

    // Wywietlamy potwierdzenie dla uytkownika:

    if ($kwota > 50) {
        include("./potwierdzenie_ladne.php");
    }
    else
    {
        include("./potwierdzenie_skromne.php");
    }

    ?>
