<?php
// Ten skrypt sprawdza, czy istniej jakie dane wejciowe 
// wysane z przegldarki. Jeli nie, wywietlany jest formularz.
// Jeli tak, dane pochodzce z formularza s sprawdzane
// i uytkownik otrzymuje komunikat potwierdzajcy. W przypadku
// nieprawidowych danych zwracana jest wypeniona wersja formularza.

    if (sizeof($_POST) == 0) {
        $kwota = 50; // proponowana kwota datku
        include("formularz_datek_wypelnienie.php");
        exit(); // zakocz skrypt!
    }

    $hack = false;  // ta zmienna logiczna sprawdza, czy nie mamy do czynienia z hakerem
    // Pobieranie danych z tablicy $_POST

    $imiedarczyncy = $_POST["imiedarczyncy"];
    $adres = $_POST["adres"];
    $kwota = $_POST["kwota"];
    $kk_rodzaj = $_POST["kk_rodzaj"];
    $kk_numer = $_POST["kk_numer"];
    $kk_data = $_POST["kk_data"];
    $publiczny = $_POST["publiczny"];
    $godzina = $_POST["godzina"];

    // Weryfikacja danych
    // $imiedarczyncy moe by dowolnym cigiem znakw
    // nie moe by tylko cigiem pustym
    if ($imiedarczyncy == "") {
        $hack = true; $pole = "Imi i nazwisko";
    }
    // $adres moe by rwnie dowolnym niepustym cigiem znakw
    if ($adres == "") {
        $hack = true; $pole = "Adres";
    }
    // Kwota musi by liczba cakowit pomidzy 5 a 100 
    if (!preg_match("/^\d*[05]$/", $kwota)) { // nie jest liczba cakowit?
        $hack = true; $pole = "Kwota";
    }
    if (($kwota < 5) || ($kwota > 100)) {
        $hack = true; $pole = "Kwota";
    }
    // Akceptowane rodzaje kart kredytowych to Visa, Mastercard, American Express 
    switch ($kk_rodzaj) {
        case "Visa": break;
        case "Mastercard": break;
        case "American Express": break;
        default:
            $hack = true; $pole = "Rodzaj karty kredytowej";
    }
    // Numer kary powinien skada si z czterech grup, 
    // z ktrych kada powinna skada si z 4 cyfr
    // ktre powinny by poczone spacj, cznikiem lub napisane w jednym cigu
    if (!preg_match("/^(\d{4}[\s\-]?){4}$/", $kk_numer)) {
        $hack = true; $pole = "Numer karty";
    }
    // Termin wanoci karty powinien skada si z 4 cyfr, przy czym
    // pierwsze dwie powinny lee w przedziale od 1 do 12 a trzecia musi
    // rwna si 0 (chyba e termin wanoci karty upywa po roku 2009
    // Czwarta cyfra musi lee pomidzy 2 a 9 

    if (!preg_match("/^(\d{2})0[2-9]$/", $kk_data, $match)) {
        $hack = true; $pole = "Termin wanoci karty";
    }
    else
    {
        if (($match[1] < 1) || ($match[1] > 12)) {
            $hack = true; $pole = "Termin wanoci karty";
        }
    }
    // Pole wyboru moe by albo puste, 'on' lub zhakowane. 
    if (($publiczny != "") && ($publiczny != "on")) {
        $hack = true; $pole = "Publikacja danych ofiarodawcy";
    }
    // Czas wypenienia formularza musi by liczb cakowit
    if (!preg_match("/^\d+$/", $godzina)) {
        $hack = true; $pole = "Czas wypenienia formularza ";
    }
  // Czy zaczono zdjcie?
     if ($_FILES["zdjeciedarczyncy"]["size"] > 0) {
         $zdjecie = true;
         preg_match("/(\.\w+)$/",
             $_FILES["zdjeciedarczyncy"]["name"],$match);
      $typ = $match[1];
      // akceptujemy tylko rozszerzenia plikw graficznych 
      if (in_array(
              strtolower($typ),
              array(".gif",".bmp",".jpg",".png",".jpeg"))) {
          $nazwapliku = uniqid("").$typ;
          $sciezka =
             preg_replace("/\/[^\/]+$/","",
                          $_SERVER["SCRIPT_FILENAME"])
                           ."/Obrazki/";
           copy($_FILES["zdjeciedarczyncy"]["tmp_name"],
                $sciezka.$nazwapliku);
       }
   }
   else
   {
      $zdjecie = false;
   }

  // Przy nieprawidowych danych zwr komunikat o bdzie:
  if ($hack) {
    include("formularz_datek_wypelnienie.php");
    exit(); // zakocz skrypt!
  }

  // W tym miejscu doczymy pniej kod wpisujcy dane do bazy danych 
  // Wywietlenie potwierdzenia:
  ?>
    <html>
      <body>
        <h1>Drogi(a) <?php echo stripslashes($imiedarczyncy); ?></h1>
            Serdeczne podzi&#281;kowania za Tw&oacute;j datek w kwocie  <?php echo $kwota ?>PLN.
            Potwierdzenie z&#322;o&#380;enia darowizny zostanie wys&#322;ane na Tw&oacute;j adres <p>
        <b><?php echo stripslashes(preg_replace("/\r?\n/","<br>",$adres)); ?></b><p>
        .<p>
        Kwota datku zostanie potr&#261;cona z Twojej karty 
        <b><?php echo $kk_rodzaj; ?></b> numer:<p>
        <b><?php echo $kk_numer; ?></b> z terminem wa&#380;no&#347;ci do
        <b><?php echo $kk_data; ?></b>.<p>
        <?php
          if ($zdjecie) { ?>
              Twoje zdj&#281;cie zobaczysz poni&#380;ej:<br>
          <img src="<?php echo "obrazki/".$nazwapliku; ?>"><p>
        <?php
        } ?>
        Przyjmujemy do wiadomo&#347;ci, &#380;e Twoich danych  
        <?php
          if ($publiczny == "") {
              echo "nie";
          }
        ?>
        mo&#380;emy opublikowa&#263;...<p>
        Na wype&#322;nienie formularza potrzebowa&#322;e&#347; <?php echo (time() - $godzina); ?>
        sekund.
      </body>
    </html>

