<?php

  // Ten skrypt sprawdza, czy istniej jakie dane wejciowe
  // wysane z przegldarki. Jeli nie, wywietlany jest formularz.
  // Jeli tak, dane pochodzce z formularza s sprawdzane i uytkownik
  // otrzymuje komunikat potwierdzajcy. W przypadku nieprawidowych
  // danych zwracana jest wypeniona wersja formularza.

  if (sizeof($_POST) == 0) {
      $kwota = 50; // proponowana wysoko darowizny
      include("formularz_datki.phpi");
      exit(); // zakocz skrypt!
  }

  // Doczenie pliku, w ktrym zebralimy klasy i funkcje 

  include("./datki_klasy.phpi");

  // Pobieranie danych z tablicy $_POST

  $imiedarczyncy = $_POST["imiedarczyncy"];
  $adres = $_POST["adres"];
  $kwota = $_POST["kwota"];
  $kk_rodzaj = $_POST["kk_rodzaj"];
  $kk_numer = $_POST["kk_numer"];
  $kk_data = $_POST["kk_data"];
  $publiczny = $_POST["publiczny"];
  $godzina = $_POST["godzina"];

  // Weryfikacja danych przeprowadzana jest w przewaajcej
  // mierze przez obiekty, ktre zbudujemy w oparciu
  // o definicje odpowiednich klas

  $darczynca = new darczynca("", $imiedarczyncy, $adres);
  $karta = new karta_kredytowa("",$kk_numer,$kk_data, $kk_rodzaj, $imiedarczyncy);
  $datek = new datek("", $kwota, $publiczny, 0, $imiedarczyncy, $kk_numer, $godzina);

  // W przypadku nieprawidowych danych wywietl odpowiedni komunikat:
  if ((!$datek->zgodny) ||
      (!$karta->zgodny) ||
       (!$darczynca->zgodny)) {
      $hack = true;
      include("formularz_datki.phpi");
      exit(); // Zakocz skrypt!
  }


  // Wywietlenie danych jako potwierdzenie:
?>
    <html>
      <body>
        <h1>Drogi/a <?php echo $darczynca->nazwisko; ?></h1>
        Serdeczne podzikowania za Twj datek w kwocie 
        <?php echo $datek->kwota ?> z.
        Potwierdzenie zoenia darowizny zostanie wysane na Twj adres <p>
        <b><?php
            echo preg_replace("/\r?\n/","<br>",
            stripslashes($darczynca->adres)); 
            ?></b><p>
        .<p>
        Kwota datku zostanie potrcona z Twojej karty <b><?php
                 echo $karte->typ; ?></b>
        numer:<p>
        <b><?php echo $karta->numer; ?></b> z terminem wanoci do 
        <b><?php echo $karta->wazna_do; ?></b>.<p>
        <?php
          if ($darczynca->zdjecie_plik) { ?>
            Swoje zdjcie zobaczysz poniej:<br>
            <img src="<?php echo "Obrazki/".$darczynca->zdjecie_plik; ?>"><p>
        <?php
        } ?>
        Przyjmujemy do wiadomoci, e 
        <?php
        if ($datek->publiczny) {
            echo "Twoje dane";
        }
        else
        {
            echo "Twoich danych nie";
 }

        ?>
        moemy opublikowa...<p>
        Na wypenienie formularza potrzebowae <?php echo (time() - $godzina); ?>
        sekund.
      </body>
    </html>

