<?php
/* captcha_image.php */

/* Dugo hasa */
$pass_length = 4;

/* Wymiary obrazu */
$width = 200;
$height = 60; 

/* cieka do czcionki TTF */
$font_path = dirname(__FILE__);

session_start(); 

/* Tworzy haso. */
$passwd = "";
$i = 0;
while ($i < $pass_length) {
    $passwd .= chr(rand(97, 122));
    $i++;
}

/* Skaduje haso. */
$_SESSION["tt_pass"] = $passwd;

/* Uzyskuje list dostpnych czcionek. */
$fonts = array(); 

if ($handle = opendir($font_path)) {
    while (false !== ($file = readdir($handle))) {
	/* Poszukuje czcionek TTF. */
	if (substr(strtolower($file), -4, 4) == '.ttf') {
	    $fonts[] = $font_path . '/' . $file;
	}
    }
}	

if (count($fonts) < 1)	{
    die("Nie znaleziono czcionek!"); 
} 

/* Nagwek obrazu: */
header("Content-Type: image/jpeg");
/* Nagwki przeciwdziaajce skadowaniu obrazu w pamici podrcznej: */
header("Expires: Mon, 01 Jul 1998 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

/* Tworzy obraz. */
$img = imagecreatetruecolor($width, $height);
  
/* Wypenia to losowym odcieniem pastelowym. */
$bg = imagecolorallocate($img, rand(210,255), rand(210,255), rand(210,255));
imagefilledrectangle($img, 0,0, $width, $height, $bg);

/* Komplikuje to obrazu, uzupeniajc je o rnokolorowe,
   czworoktne figury. */
  
/* Tworzy linie gruboci od 10 do 30 pikseli rozcigajce si na caym obrazie. */
$right = rand(10, 30);
$left = 0;
while ($left < $width) {
    $poly_points = array(
	$left, 0,                                 /* Lewy, grny naronik */
        $right, 0,                                /* Prawy, grny naronik */
        rand($right-25, $right+25), $height,      /* Prawy, dolny naronik */
        rand($left-15, $left+15), $height);       /* Lewy, dolny naronik */
    
    /* Tworzy wielokt, wykorzystujc losowe punkty skadowane w tablicy. */
    $c = imagecolorallocate($img, rand(210,255), rand(210,255), rand(210,255));
    imagefilledpolygon($img, $poly_points, 4, $c);
	
    /* Zblia si do prawej krawdzi. */
    $random_amount = rand(10, 30); 
    $left += $random_amount;
    $right += $random_amount; 
}

/* Wybiera podstawowy przedzia wartoci kolorw dla pionowych i poziomych linii. */
$c_min = rand(120, 185);
$c_max = rand(195, 280);

/* Rysuje przypadkowe, pionowe linie na caej szerokoci obrazu. */
$left = 0;
while ($left < $width) {
    $right = $left + rand(3, 7);
    $offset = rand(-3, 3);                       /* Przesunicie decydujce o nachyleniu */
	
    $line_points = array(
        $left, 0,                                /* Lewy, grny naronik */
        $right, 0,                               /* Prawy, grny naronik */
        $right + $offset, $height,               /* Prawy, dolny naronik */
        $left + $offset, $height);               /* Lewy, dolny naronik */
	
    $pc = imagecolorallocate($img, rand($c_min, $c_max),
                                   rand($c_min, $c_max),
                                   rand($c_min, $c_max));
    imagefilledpolygon($img, $line_points, 4, $pc);
	
    /* Zblia si do prawej krawdzi. */
    $left += rand(20, 60);
}
  
/* Rysuje przypadkowe, poziome linie na caej wysokoci obrazu. */
$top = 0; 
while ($top < $height) {
    $bottom = $top + rand(1, 4);
    $offset = rand(-6, 6);                    /* Przesunicie decydujce o nachyleniu */
	
    $line_points = array(
        0, $top,                              /* Lewy, grny naronik */
        0, $bottom,                           /* Lewy, dolny naronik */
        $width, $bottom + $offset,            /* Prawy, dolny naronik */
        $width, $top + $offset);              /* Prawy, grny naronik */
    $pc = imagecolorallocate($img, rand($c_min, $c_max),
				   rand($c_min, $c_max),
				   rand($c_min, $c_max));
    imagefilledpolygon($img, $line_points, 4, $pc);
    $top += rand(8, 15);
}
  
/* Okrela odlego dzielc znaki. */
$spacing = $width / (strlen($passwd)+2);

/* Pocztkowa wsprzdna pozioma */
$x = $spacing; 

/* Rysuje poszczeglne znaki. */
for ($i = 0; $i < strlen($passwd); $i++) {
    $letter = $passwd[$i];
    $size = rand($height/3, $height/2);
    $rotation = rand(-30, 30);
	 
    /* Losowa wsprzdna pionowa z przestrzeni na wysze znaki */
    $y = rand($height * .90, $height - $size - 4);

    /* Wybiera losow czcionk. */
    $font = $fonts[array_rand($fonts)];

    /* Wybiera kolor dla danej litery. */
    $r = rand(100, 255); $g = rand(100, 255); $b = rand(100, 255);

    /* Tworzy kolory samej litery i jej cienia. */
    $color = imagecolorallocate($img, $r, $g, $b);
    $shadow = imagecolorallocate($img, $r/3, $g/3, $b/3);
	 
    /* Rysuje kolejno cie litery i sam liter. */
    imagettftext($img, $size, $rotation, $x, $y, $shadow, $font, $letter);
    imagettftext($img, $size, $rotation, $x-1, $y-3, $color, $font, $letter);

    /* Przechodzi do kolejnej pozycji na danej kanwie. */
    $x += rand($spacing, $spacing * 1.5);  
}

imagejpeg($img);          /* Wysya gotowy obraz. */
imagedestroy($img);       /* Zwalnia pami obrazu. */

?>
