<?php
/* Konfiguracja */

$root = "/home/www/wcphp/images";               /* Katalog gwny obrazw */
$urlroot = "http://www.example.com/images";     /* Adres URL katalogu gwnego */
$max_width = 420;                               /* Maksymalna szeroko */
$max_height = 600;                              /* Maksymalna wysoko */
$overwrite_images = false;                      /* Moliwo nadpisywania obrazw */

/* Udostpniane podkatalogi */
$target_dirs = array("article", "banners");

/* Koniec konfiguracji */

if (!function_exists(getimagesize)) {
    die("Funkcja getimagesize() jest wymagana.");
}

/* Uzyskuje informacje o nadesanym obrazie. */
$location = strval($_POST['location']);
$newname = strval($_POST['newname']);
$upfile = $_FILES['upfile']['tmp_name'];
$upfile_name = $_FILES['upfile']['name'];

/* Usuwa wszelkie niepodane znaki z docelowej nazwy pliku obrazu. */
if ($newname) {
    $newname = preg_replace('/[^A-Za-z0-9_.-]/', '', $newname);
} else {
    $newname = preg_replace('/[^A-Za-z0-9_.-]/', '', $upfile_name);
}

/* Weryfikacja poprawnoci parametrw. */
if (!in_array($location, $target_dirs)) {
    /* Nieprawidowe pooenie */
    die("invalid target directory.");
} else {
    $urlroot .= "/$location";
}

if (!$upfile) {
    /* Brak pliku */
    die("Brak pliku do wysania.");
}

/* Weryfikacja typu pliku. */
$file_types = array(
    "image/jpeg"	=> "jpg",
    "image/pjpeg"	=> "jpg",
    "image/gif"		=> "gif",
    "image/png"		=> "png",
);
$width = null;
$height = null; 

/* Wyodrbnia typ MIME oraz rozmiar danego obrazu. */
$img_info = getimagesize($upfile);
$upfile_type = $img_info["mime"];
list($width, $height, $t, $attr) = $img_info;

/* Weryfikacja typu. */
if (!$file_types[$upfile_type]) {
    die("Obraz musi mie format JPEG, GIF lub PNG.");
} else {
    $file_suffix = $file_types[$upfile_type];
}

/* Weryfikacja rozmiaru. */
if ($width > $max_width || $height > $max_height) {
    die("Rozmiar $width x $height przekracza maksimum: $max_width x $max_height.");
}

/* Wymusza waciwy przyrostek (rozszerzenie). */
$newname = preg_replace('/\.(jpe?g|gif|png)$/i', "", $newname);
$newname .= ".$file_suffix";
$new_fullpath = "$root/$location/$newname";

if ((!$overwrite_images) && file_exists($new_fullpath)) {
    die("Taki plik ju istnieje; jego nadpisanie jest niemoliwe.");
}

/* Kopiuje plik do katalogu docelowego. */
if (!copy($upfile, $new_fullpath)) {
    die("Prba kopiowania zakoczona niepowodzeniem.");
}

$image_url = "$urlroot/$newname";

/* Wywietla status. */
print "HTML for image:</strong><br><textarea cols=\"80\" rows=\"4\">";
print "<img src=\"$image_url\" $attr alt=\"$newname\" border=\"0\"/>";
print "</textarea><br>";
print '<a href="upload.html">Chcesz wysa nastpny obraz?</a>';

?>
