<?php

function suggest_spelling($string) {
    // Sugeruje prawidowe wyrazy anglojzyczne dla acuchw z bdami.
    $dict_config = pspell_config_create('en', 'american');
    pspell_config_ignore($dict_config, 3);
    pspell_config_mode($dict_config, PSPELL_FAST);
    $dictionary = pspell_new_config($dict_config);
    
    // Dziki tej zmiennej bdziemy wiedzieli na pewno, czy cokolwiek zasugerowano.
    $suggested_replacement = false;
    
    // Skoro skonfigurowano ju rodowisko, rozbijamy acuch wejciowy na wyrazy.
    $string = explode(' ', $string);
    foreach ($string as $key=>$value) {
        $value = trim(str_replace(',', '', $value));
        if ( (strlen($value) > 3) && (! pspell_check($dictionary, $value)) ) {
            // Jeli nie mona znale adnych sugestii...
            $suggestion = pspell_suggest($dictionary, $value);
            // Wielko liter w sugestiach jest istotna, zatem najpierw dokonujemy odpowiedniego sprawdzenia:
            if (strtolower($suggestion[0]) != strtolower($value)) {
                $string[$key] = $suggestion[0]; 
                $suggested_replacement = true;
            }
        }
    }

    if ($suggested_replacement) {
        // Mamy sugesti, zatem moemy zwrci jakie dane.
        return implode(' ', $string); 
    } else {
        return null;
    }
}


print suggest_spelling("doofburger");

print "\n";

?>
