﻿<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<title>Klasy Reflection</title>
<meta name="description" content="" />
<meta name="keywords" content="" />
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta name="author" content="Peter Lavin" />
<meta http-equiv="Content-Language" content="PL" />
<meta name="robots" content="FOLLOW,INDEX" />
<meta name="abstract"
content="" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<!--lokalne style elementów-->
<style type="text/css">
body{
  font-family: courier;
  font-size: 10pt;
}
div{
  font-family: verdana, arial, helvetica, sans-serif;
}
h1, h2, h3, h4{
  color:#666;
  font-family: verdana, arial, helvetica, sans-serif;
  background-color:#bbb;
}
h1 { 
  font-size: 170%; 
}
h2 {
  font-size: 150%; 
}
h3 { 
  font-size: 120%; 
}
h4 { 
  font-size: 100%;
}
td.top{
  padding-bottom:5px;
  border-bottom:dotted 1px black;
}
td.centre{
  width:80%;
  vertical-align:top;
  border-left: 1px dotted black; 
  padding-left:15px;padding-top:10px;
}
span.keyword{
  color:blue;
  font-weight: bold;  
}
span.name{
  font-weight: bold;
}
span.comment{
  font-style:italic;
}
span.fulldescription{
  font-size: larger; 
}
label{
  font-family: verdana, arial, helvetica, sans-serif;
}
@media print{
  body{ 
    margin:0px; 
  }
  /* błąd w Firefox - czcionką segmentu nie może być courier*/
  span{    
    font-family: helvetica;
  }
  td.top{
    border:none;
  }
  td.centre{
    border:none;
  }
  td.sidebar{
    display:none;
  }  
  h1, h2, h3, h4{
    background-color: #fff;
  }
}
</style>
</head>
<body>
<table style="width:770px;">
<tr>
<td colspan="2" class="top" >
<h1 style="background-color:#fff">Klasy i interfejsy PHP</h1>
</td>
</tr>
<tr>
<td style="width:20%; vertical-align:top;padding-top:10px;" class="sidebar">
<?php
include 'MySQLException.php';
include 'Documenter.php';
$arr = get_declared_classes();
natcasesort($arr);
$classname = @$_GET["class"];
if(!isset($classname)){
  $classname = current($arr);
}
echo "<h4 style=\"background-color:#fff;\">Klasy</h4>";
foreach($arr as $value){
  echo "<a href=\"getclass.php?class=$value\">".
    "$value</a><br />\n";
}
$arr = get_declared_interfaces();
natcasesort($arr);
echo "<h4 style=\"background-color:#fff;\">Interfejsy</h4>";
foreach($arr as $key => $value){
  echo "<a href=\"getclass.php?class=$value\">".
    "$value</a><br />\n";
}
?>
</td>
<td class="centre" >
<?php
//////////////////////////////////////////////////////////////////////
function get_params(ReflectionParameter $p){  
  $description = "";
  //sprawdza, czy to obiekt
  $c = $p->getClass();
  if(is_object($c)){
    $description .= $c->getName() . " ";
  }
  $description .= "\$" . $p->getName();
  //sprawdza wartości domyślne
  if ($p->isDefaultValueAvailable()){
    $val = $p->getDefaultValue();
    //może być ousty łańcuch
    if($val == ""){
      $val = "\"\"";
    }
    $description .= " = $val";
  }  
  return $description;
}
//////////////////////////////////////////////////////////////////////
//Uwaga: kontrola typów tablic wymaga wersji 5.1
//////////////////////////////////////////////////////////////////////
function show_methods(Documenter $d, $type, $arr){
  echo "<h3>$type</h3>";
  foreach($arr as $key => $value){  
    echo "<p><span class=\"keyword\">".
      $d->getModifiers($value). "</span> ".
      "<span class=\"name\">$key</span>\n";
    //dodaje parametry dzięki metodzie klasy ReflectionMethod
    $params = $value->getParameters();
    $number= $value->getNumberOfParameters();
    $counter = 0;
    echo "( " ; 
    foreach($params as $p){    
      echo get_params($p);
      $counter ++;
      if($counter != $number){
        echo ", ";
      }
    }
    echo " )" ;
    if($value->isUserDefined()){
      echo " zdefiniowana przez użytkownika<br />";
    }
    if($value->getDocComment()){
      echo "<span class=\"comment\">";
      echo $value->getDocComment() . "</span><br />";
    }
    echo "</p>";
  }
}
//////////////////////////////////////////////////////////////////////
function show_data_members(Documenter $d, $type, $arr){
  $arrdefaultvalue = $d->getDefaultproperties();
  echo "<h3>$type</h3>\n";
  foreach($arr as $key => $value){  
    $strtemp = "<p><span class=\"keyword\">".
      $d->getModifiers($value) . "</span> ".
      "<span class=\"name\">$key</span>";
    if ( isset($arrdefaultvalue[$key]) ){
      $val = $arrdefaultvalue[$key];
      //uwaga - wartości logiczne nie posiadają wartości
      if(!is_numeric($val)){
        if (is_array($val)){
          $val = " array()";
        }else{
          $val = "\"$val\"";
        }        
      }
      $strtemp .= " = $val";
      /* getDocComment()  dla właściwości została dodana w PHP 5.1.0., ale nie działała aż do wersji 5.1.3 */
      /*if($value->getDocComment()){
        $strtemp .= "<br /><span class=\"comment\">";
        $strtemp .= $value->getDocComment() . "</span><br />";
      }*/
    }
    echo $strtemp;
    echo "</p>\n";
  }
}
//////////////////////////////////////////////////////////////////////
//główna
try{
  $class = new Documenter($classname);
  echo "<h2>Nazwa: ". $class->getName() . "</h2>\n";
  if(function_exists('date_default_timezone_set')){
    date_default_timezone_set("Canada/Eastern");
  }
  $today = date("M-d-Y");
  echo "<p> Data: $today<br />";
  echo "Wersja PHP: ". phpversion() . "<br />";
  echo "Typ: ". $class->getClassType() . "<br /><br />\n";
  echo "<span class=\"fulldescription\">". $class->getFullDescription().
         "</span><br /><br />\n";
  echo "<span class=\"comment\">";
  echo $class->getDocComment() . "</span></p>\n";  
  $arr = $class->getPublicMethods();
  if (count ($arr) > 0){
    show_methods($class, "Metody publiczne", $arr);
  }
  $arr = $class->getProtectedMethods();
  if (count($arr) > 0){
    show_methods($class, "Metody chronione", $arr);
  }
  $arr = $class->getPrivateMethods();
  if (count($arr) > 0){
    show_methods($class, "Metody prywatne", $arr);
  }
  //wypisuje dane składowe
  $arr = $class->getPublicDataMembers();
  if (count($arr) > 0){
    show_data_members($class, "Publiczne dane składowe", $arr);
  }
  $arr = $class->getProtectedDataMembers();
  if (count($arr) > 0){
    show_data_members($class, "Chronione dane składowe", $arr);
  }
  $arr = $class->getPrivateDataMembers();
  if (count($arr) > 0){
    show_data_members($class, "Prywatne dane składowe", $arr);
  }
  $arr = $class->getConstants();
  if (count($arr) > 0){
    echo "<h3>Stałe</h3>\n";
    foreach ($arr as $key => $value){
      echo "<p><span class=\"keyword\">const</span> ".
        "<span class=\"name\">$key</span> = $value <br /></p>\n";
    }
  }
}
catch (ReflectionException $e){
  echo "<div style=\"color:red; font-size: 12pt; font-weight: bold;\">";
  echo "ReflectionException<br /><br /></div>";
  echo $e;
}
?>
</td>
</tr>
</table>
</body>
</html>
