﻿<?php
require 'MySQLResultSet.php';
require 'MySQLException.php';
////////////////////////////////////////////////////////////////////
/**
Implementacja klasy połączenia, która bardziej odpwiada wzorcowi singleton.
*/
class MySQLConnect{
  //dane składowe
  private static $instance = NULL;
  private $connection;
  const ONLY_ONE_INSTANCE_ALLOWED = 5000;

////////////////////////////////////////////////////////////////////
//konstruktor
////////////////////////////////////////////////////////////////////
/**
prywatny konstruktor - wywoływany ze statycznej metody getInstance
*/
  private function __construct($hostname, $username, $password){
    if(!$this->connection = mysql_connect($hostname, $username,$password )){
      throw new MySQLException(mysql_error(), mysql_errno());
    }
  }
////////////////////////////////////////////////////////////////////
//destruktor
////////////////////////////////////////////////////////////////////
  public function __destruct(){
    $this->close();
  }
////////////////////////////////////////////////////////////////////
// metody publiczne
////////////////////////////////////////////////////////////////////
/**
Metoda statyczna, która tworzy egzemplarz klasy, jeśli taki już nie istnieje.
*/
  static public function getInstance($hostname, $username, $password){
    //instancja musi być statyczna, aby tu mogło pojawić się odwołanie
    if(self::$instance == NULL ){
      self::$instance = new MySQLConnect($hostname, $username, $password);
      return self::$instance;
    }else{
      $msg = "Zamknij istniejący egzemplarz ".
        "klasy MySQLConnect.";
      throw new MySQLException($msg, self::ONLY_ONE_INSTANCE_ALLOWED);
    }
  }
////////////////////////////////////////////////////////////////////
  public function createResultSet($strSQL, $databasename){
    $rs = new MySQLResultSet($strSQL, $databasename, $this->connection );
    return $rs;
  }
//////////////////////////////////////////////////////////////////// 
  public function getConnection(){
    return $this->connection;
  }
//////////////////////////////////////////////////////////////////// 
  public function getVersionNumber(){
    //mysql_get_server_info
    return mysql_get_server_info();
  }
////////////////////////////////////////////////////////////////////
   public function close(){
    if(isset($this->connection)){
      mysql_close($this->connection);
      unset($this->connection);      
    }
    self::$instance = NULL;
  }
}//koniec klasy
////////////////////////////////////////////////////////////////////
?>
