﻿<?php
/////////////////////////////////////////////////////////////////
/**
Tworzy tablicę plików w katalogu
*/
/////////////////////////////////////////////////////////////////
class DirectoryItems{
	//dane składowe
	var $filearray = array();
	var $replacechar;
	var $directory;
//////////////////////////////////////////////////////////////////
//konstrukor
/////////////////////////////////////////////////////////////////
   function DirectoryItems($directory, $replacechar = "_"){
		$this->directory = $directory;
		$this->replacechar = $replacechar;
		$d = "";
  	if(is_dir($directory)){
  		$d = opendir($directory) or die("Nie można otworzyć katalogu.");
  		while(false !== ($f = readdir($d))){
    		if(is_file("$directory/$f")){
					$title = $this->createTitle($f);
					$this->filearray[$f] = $title;
    		}
  		}
			closedir($d);
		}else{
			//błąd
			die("Zrezygnowano z dostępu do katalogu.");
		}
	}
//////////////////////////////////////////////////////////////////
//destruktor - nie wywoływany automatycznie
//////////////////////////////////////////////////////////////////
	 function __destruct(){
		unset($this->filearray);
	}
//////////////////////////////////////////////////////////////////
// funkcje publiczne
//////////////////////////////////////////////////////////////////
	 function getDirectoryName(){
		return $this->directory;
	}
//////////////////////////////////////////////////////////////////
	 function indexOrder(){
		sort($this->filearray);
	}
//////////////////////////////////////////////////////////////////
	 function naturalCaseInsensitiveOrder(){
		natcasesort($this->filearray);
	}
//////////////////////////////////////////////////////////////////
//zwraca wartość false, jeśli nie wszystkie pliki są tych typów
//////////////////////////////////////////////////////////////////
	 function checkAllImages(){
		$bln = true;
		$extension = "";
		$types = array("jpg", "jpeg", "gif", "png");
		foreach ($this->filearray as $key => $value){
			$extension = substr($key,(strpos($key, ".")+1));
			$extension = strtolower($extension);
			if(!in_array($extension, $types)){
				$bln = false;
				break;
			}
		}
		return $bln;
	}
//////////////////////////////////////////////////////////////////
//zwaraca wartość false, jeśli nie wszystkie są o określonym rozszerzeniu
//////////////////////////////////////////////////////////////////
	 function checkAllSpecificType($extension){
		$extension = strtolower($extension);
		$bln = true;
		$ext = "";
		foreach ($this->filearray as $key => $value){
			$ext = substr($key,(strpos($key, ".")+1));
			$ext = strtolower($ext);
			if($extension != $ext){
				$bln=false;
				break;
			}
		}
		return $bln;
	}
//////////////////////////////////////////////////////////////////
	 function getCount(){
		return count($this->filearray);
	}
//////////////////////////////////////////////////////////////////
	 function getFileArray(){
		return $this->filearray;
	}
//////////////////////////////////////////////////////////////////
//do użycia z nawigatorem - faza 3
/////////////////////////////////////////////////////////////////
	 function getFileArraySlice($start, $length){
		return array_slice($this->filearray, $start, $length);
	}
//////////////////////////////////////////////////////////////////
//eliminuje te elementy tablicy, które nie należą do grupy o podanych rozszerzeniach - faza 2
/////////////////////////////////////////////////////////////////
	 function filter($extension){
		$extension = strtolower($extension);
		foreach ($this->filearray as $key => $value){
			$ext = substr($key,(strpos($key, ".") + 1));
			$ext = strtolower($ext);
			if($ext != $extension){
				unset($this->filearray[$key]);
			}
		}
	}
//////////////////////////////////////////////////////////////////
//eliminuje wszystkie elementy tablicy, które nie są obrazami - faza 2
/////////////////////////////////////////////////////////////////
	 function imagesOnly(){
		$extension = "";
		$types = array("jpg", "jpeg", "gif", "png");
		foreach ($this->filearray as $key => $value){
			$extension = substr($key,(strpos($key, ".") + 1));
			$extension = strtolower($extension);
			if(!in_array($extension, $types)){
				unset($this->filearray[$key]);
			}
		}	
	}
//////////////////////////////////////////////////////////////////
//odtwarza tablice po filtrowaniu - faza 2
/////////////////////////////////////////////////////////////////
	 function removeFilter(){
		unset($this->filearray);
		$d = "";
		$d = opendir($this->directory) or die($php_errormsg);
		while(false!==($f=readdir($d))){
  		if(is_file("$this->directory/$f")){
				$title = $this->createTitle($f);
				$this->filearray[$f] = $title;
  		}
		}
		closedir($d);
	}	
//////////////////////////////////////////////////////////////////
//funkcje prywatne
/////////////////////////////////////////////////////////////////
	function createTitle($title){
		//oddziela rozszerzenie
		$title = substr($title,0,strrpos($title, "."));
		//zamienia znak separator w nazwie pliku na spację
		$title = str_replace($this->replacechar, " ", $title);
		return $title;
	}
}//koniec klasy
?>
