﻿<?php
/////////////////////////////////////////////////////////////////
/*Jeśli katalog i jego podkatalogi zostaną należycie utworzone, to moga działać, jak tabele bazy danych, a w niektórych bazach tym właśnie jest tabela. Klasa DirectoryItems
pobierze "rekordy" ze wskazanego katalogu. Właściwie nadane 

Properly ordered and created, a directory and its subdirectories can function like tables in a database - in fact for some databases that's exactly what a table is. The DirectoryItems class will retrieve the "records" in a specific directory. Properly assigned file names can function as the "title" of a file by stripping out underscores and the file extension, i.e. Lady_of_Shallot.jpg. A directory may be checked to ensure that all files contained in it are a specific type or have the same extension.
Use filemtime() as another field - useful for ordering by.
Use filesize() as another field or fstat() for other info.
Order by file extension and then alphabetically.*/
/////////////////////////////////////////////////////////////////
class DirectoryItems
{
	//dane składowe
	private $filearray = array();
	private $replacechar;
	private $directory;
//////////////////////////////////////////////////////////////////
//konstrukor
/////////////////////////////////////////////////////////////////
  public function __construct($directory, $replacechar = "_")
  {
		$this->directory = $directory;
		$this->replacechar = $replacechar;
		$d = "";
  	if(is_dir($directory))
    {
  		$d = opendir($directory) or die("Nie można otworzyć katalogu.");
  		while(false !== ($f = readdir($d)))
      {
    		if(is_file("$directory/$f"))
        {
					$title = $this->createTitle($f);
					$this->filearray[$f] = $title;
    		}
  		}
			closedir($d);
		}
    else
    {
			//błąd
			die("Zrezygnowano z dostępu do katalogu.");
		}
	}
//////////////////////////////////////////////////////////////////
//destruktor
//////////////////////////////////////////////////////////////////
	public function __destruct()
  {
		unset($this->filearray);
	}
//////////////////////////////////////////////////////////////////
//funkcje publiczne
//////////////////////////////////////////////////////////////////
	public function getDirectoryName()
  {
		return $this->directory;
	}
//////////////////////////////////////////////////////////////////
	public function indexOrder()
  {
		sort($this->filearray);
	}
//////////////////////////////////////////////////////////////////
	public function naturalCaseInsensitiveOrder()
  {
		natcasesort($this->filearray);
	}
//////////////////////////////////////////////////////////////////
//zwraca wartość false, jeśli nie wszystkie pliki są tych typów
//////////////////////////////////////////////////////////////////
	public function checkAllImages()
  {
		$bln = true;
		$extension = "";
		$types = array("jpg", "jpeg", "gif", "png");
		foreach ($this->filearray as $key => $value)
    {
			$extension = substr($key,(strpos($key, ".")+1));
			$extension = strtolower($extension);
			if(!in_array($extension, $types))
      {
				$bln = false;
				break;
			}
		}
		return $bln;
	}
//////////////////////////////////////////////////////////////////
//zwaraca wartość false, jeśli nie wszystkie są o określonym rozszerzeniu
//////////////////////////////////////////////////////////////////
	public function checkAllSpecificType($extension)
  {
		$extension = strtolower($extension);
		$bln = true;
		$ext = "";
		foreach ($this->filearray as $key => $value)
    {
			$ext = substr($key,(strpos($key, ".")+1));
			$ext = strtolower($ext);
			if($extension != $ext)
      {
				$bln=false;
				break;
			}
		}
		return $bln;
	}
//////////////////////////////////////////////////////////////////
	public function getCount()
  {
		return count($this->filearray);
	}
//////////////////////////////////////////////////////////////////
	public function getFileArray()
  {
		return $this->filearray;
	}
//////////////////////////////////////////////////////////////////
//do użycia z nawigatorem - faza 3
/////////////////////////////////////////////////////////////////
	public function getFileArraySlice($start, $length)
  {
		return array_slice($this->filearray, $start, $length);
	}
//////////////////////////////////////////////////////////////////
//eliminuje te elementy tablicy, które nie należą do grupy o podanych rozszerzeniach - faza 2
/////////////////////////////////////////////////////////////////
	public function filter($extension)
  {
		$extension = strtolower($extension);
		foreach ($this->filearray as $key => $value)
    {
			$ext = substr($key,(strpos($key, ".") + 1));
			$ext = strtolower($ext);
			if($ext != $extension)
      {
				unset($this->filearray[$key]);
			}
		}
	}
//////////////////////////////////////////////////////////////////
//eliminuje wszystkie elementy tablicy, które nie są obrazami - faza 2
/////////////////////////////////////////////////////////////////
	public function imagesOnly()
  {
		$extension = "";
		$types = array("jpg", "jpeg", "gif", "png");
		foreach ($this->filearray as $key => $value)
    {
			$extension = substr($key,(strpos($key, ".") + 1));
			$extension = strtolower($extension);
			if(!in_array($extension, $types))
      {
				unset($this->filearray[$key]);
			}
		}	
	}
//////////////////////////////////////////////////////////////////
//odtwarza tablice po filtrowaniu - faza 2
/////////////////////////////////////////////////////////////////
	public function removeFilter()
  {
		unset($this->filearray);
		$d = "";
		$d = opendir($this->directory) or die($php_errormsg);
		while(false!==($f=readdir($d)))
    {
  		if(is_file("$this->directory/$f"))
      {
				$title = $this->createTitle($f);
				$this->filearray[$f] = $title;
  		}
		}
		closedir($d);
	}	
//////////////////////////////////////////////////////////////////
//funkcje prywatne
/////////////////////////////////////////////////////////////////
	private function createTitle($title)
  {
		//oddziela rozszerzenie
		$title = substr($title,0,strrpos($title, "."));
		//zamienia znak separator w nazwie pliku na spację
		$title = str_replace($this->replacechar, " ", $title);
		return $title;
	}
}//koniec klasy	
?>
