﻿<?php
////////////////////////////////////////////////////////////////////
/**
Klasa nawigatora
*/
class PageNavigator{
  //dane składowe
  var $pagename;
  var $totalpages;
  var $recordsperpage;
  var $maxpagesshown;
  var $currentstartpage;
  var $currentendpage;
  var $currentpage;
  //następa i poprzednia - nieaktywne
  var $spannextinactive;
  var $spanpreviousinactive;
  //pierwsza i ostatnia - nieaktywne
  var $firstinactivespan;
  var $lastinactivespan;  
  //musi odpowiadać $_GET['offset'] na wywoływanej stronie
  var $firstparamname = "offset";
  //wykorzystane do pobrania jako para "&name=value"
  var $params;
  //nazwy klasy css
  var $inactivespanname = "inactive";
  var $pagedisplaydivname = "totalpagesdisplay";
  var $divwrappername = "navigator";
  //tekst
  var $strfirst = "|&lt;";
  var $strnext = "Następna";
  var $strprevious = "Poprzednia";
  var $strlast = "&gt;|";
  //zgłaszanie błędów
  var $errorstring;  
////////////////////////////////////////////////////////////////////
//konstruktor
////////////////////////////////////////////////////////////////////
   function PageNavigator($pagename, $totalrecords, $recordsperpage, $recordoffset, $maxpagesshown = 4, $params = ""){
    $this->pagename = $pagename;
    $this->recordsperpage = $recordsperpage;  
    $this->maxpagesshown = $maxpagesshown;
    //już zakodowane jako url
    $this->params = $params;
    //sprawdza czy recordoffset jest wielokrotnością recordsperpage
    $this->checkRecordOffset($recordoffset, $recordsperpage) or
      die($this->errorstring);
    $this->setTotalPages($totalrecords, $recordsperpage);
    $this->calculateCurrentPage($recordoffset, $recordsperpage);
    $this->createInactiveSpans();
    $this->calculateCurrentStartPage();
    $this->calculateCurrentEndPage();
  }
////////////////////////////////////////////////////////////////////
//metody publiczne
////////////////////////////////////////////////////////////////////
//nadaje klasie css nazwę nieaktywnej przestrzeni
////////////////////////////////////////////////////////////////////
   function setInactiveSpanName($name){
    $this->inactivespanname = $name;
    //wywołuje funkcję zmieniającą nazwę przestrzni
    $this->createInactiveSpans();  
  }
////////////////////////////////////////////////////////////////////
   function getInactiveSpanName(){
    return $this->inactivespanname;
  }
////////////////////////////////////////////////////////////////////
   function setPageDisplayDivName($name){
    $this->pagedisplaydivname = $name;    
  }
////////////////////////////////////////////////////////////////////
   function getPageDisplayDivName(){
    return $this->pagedisplaydivname;
  }
////////////////////////////////////////////////////////////////////
   function setDivWrapperName($name){
    $this->divwrappername = $name;    
  }
////////////////////////////////////////////////////////////////////
   function getDivWrapperName(){
    return $this->divwrappername;
  }
////////////////////////////////////////////////////////////////////
   function setFirstParamName($name){
    $this->firstparamname = $name;    
  }
////////////////////////////////////////////////////////////////////
   function getFirstParamName(){
    return $this->firstparamname;
  }
////////////////////////////////////////////////////////////////////
/**
zwraca kod HTML nawigatora
*/
   function getNavigator(){
    //wrap in div tag
    $strnavigator = "<div class=\"$this->divwrappername\">\n";
    //wyświetla przycisk przejścia do pierwszej strony   
    if($this->currentpage == 0){
      $strnavigator .= $this->firstinactivespan;
    }else{
      $strnavigator .= $this->createLink(0, $this->strfirst);
    }
    //wyświetla przycisk przejścia do poprzedniej strony
    if($this->currentpage == 0){
      $strnavigator .= $this->spanpreviousinactive;
    }else{
      $strnavigator.= $this->createLink($this->currentpage-1, $this->strprevious);
    }
    //sprawdza w pętli wyświetlone strony rozpoczynając od $currentstart
    for($x = $this->currentstartpage; $x < $this->currentendpage; $x++){
      //bieżąca strona nieaktywna
      if($x == $this->currentpage){
        $strnavigator .= "<span class=\"$this->inactivespanname\">";
        $strnavigator .= $x+1;
        $strnavigator .= "</span>\n";
      }else{
        $strnavigator .= $this->createLink($x, $x+1);
      }
    }
    //przycisk "następna"     
    if($this->currentpage == $this->totalpages-1){
      $strnavigator .= $this->spannextinactive;      
    }else{
      $strnavigator .= $this->createLink($this->currentpage + 1, $this->strnext);
    }
    //przejdź do ostatniej
    if($this->currentpage == $this->totalpages-1){
      $strnavigator .= $this->lastinactivespan;
    }else{
      $strnavigator .= $this->createLink($this->totalpages -1, $this->strlast);
    }
    $strnavigator .=  "</div>\n";
    $strnavigator .= $this->getPageNumberDisplay();
    return $strnavigator;
  }
////////////////////////////////////////////////////////////////////
//metody prywatne
////////////////////////////////////////////////////////////////////
   function createLink($offset, $strdisplay ){
    $strtemp = "<a href=\"$this->pagename?$this->firstparamname=";
    $strtemp .= $offset;
    $strtemp .= "$this->params\">$strdisplay</a>\n";
    return $strtemp;
  }
////////////////////////////////////////////////////////////////////  
   function getPageNumberDisplay(){
    $str = "<div class=\"$this->pagedisplaydivname\">\nPage ";
    $str .= $this->currentpage+1;
    $str .= " of $this->totalpages";
    $str .= "</div>\n";
    return $str;
  }
////////////////////////////////////////////////////////////////////
   function setTotalPages($totalrecords, $recordsperpage){
    $this->totalpages = ceil($totalrecords/$recordsperpage);
  }
////////////////////////////////////////////////////////////////////
   function checkRecordOffset($recordoffset, $recordsperpage){
    $bln = true;
    if($recordoffset%$recordsperpage != 0){
      $this->errorstring = "Error - not a multiple of records per page.";
      $bln = false;  
    }
    return $bln;
  }
////////////////////////////////////////////////////////////////////  
   function calculateCurrentPage($recordoffset, $recordsperpage){
    $this->currentpage = $recordoffset/$recordsperpage;
  }
////////////////////////////////////////////////////////////////////
// nie zawsze potzebna
////////////////////////////////////////////////////////////////////
   function createInactiveSpans(){
    $this->spannextinactive = "<span class=\"".
      "$this->inactivespanname\">$this->strnext</span>\n";
    $this->lastinactivespan = "<span class=\"".
      "$this->inactivespanname\">$this->strlast</span>\n";
    $this->spanpreviousinactive = "<span class=\"".
      "$this->inactivespanname\">$this->strprevious</span>\n";
    $this->firstinactivespan = "<span class=\"".
      "$this->inactivespanname\">$this->strfirst</span>\n";
  }
////////////////////////////////////////////////////////////////////
//znajduje stronę startową bazując na aktualnej stronie
////////////////////////////////////////////////////////////////////
   function calculateCurrentStartPage(){
    $temp = floor($this->currentpage/$this->maxpagesshown);
    $this->currentstartpage = $temp * $this->maxpagesshown;
  }
////////////////////////////////////////////////////////////////////
   function calculateCurrentEndPage(){
    $this->currentendpage = $this->currentstartpage+$this->maxpagesshown;
    if($this->currentendpage > $this->totalpages)
    {
      $this->currentendpage = $this->totalpages;
    }
  }
}//koniec klasy
////////////////////////////////////////////////////////////////////
?>
