﻿<?php
//wymaga GD 2.0.1 lub wyższezj
class ThumbnailImage{
	//prywatne dane składowe
	var $image;
	var $maxdimension;
	//nie odnosi się do gif i png
	var $quality=100;
	var $fileextension;
	var $mimetype;
	var $imageproperties;
	var $types= array("jpg", "jpeg", "gif", "png");
////////////////////////////////////////////////////////
//konstruktor
////////////////////////////////////////////////////////
	function ThumbnailImage($path, $maxdimension=100){
		$this->maxdimension=$maxdimension;
		//sprawdza sieżkę
		is_file($path) or die ("Plik: $file nie istnieje.");
		//sprawdza typ	
		$extension=substr($path,(strpos($path, ".")+1));
		$extension= strtolower($extension);
		in_array($extension, $this->types) or die ("Niepoprawne rozszerzenie.");
		$this->fileextension=$extension;
		$this->setMimeType($extension);
		//pobiera rozszerzenia poprzez utworzenie właściwości obrazu
		$this->imageproperties = GetImageSize($path);		
		//tworzy obraz
		if($extension=="jpeg" || $extension=="jpg"){
			$this->image=imagecreatefromJPEG($path);			
		}elseif($extension=="gif"){
			$this->image=imagecreatefromGIF($path);
		}elseif($extension=="png"){
			$this->image=imagecreatefromPNG($path);
		}else{
			die("Nie można utworzyć obrazu.");
		}
		$this->createThumb();
	}
////////////////////////////////////////////////////////
//metody publiczne
////////////////////////////////////////////////////////
	function getImage(){
		header("Content-type: $this->mimetype");
		if($this->fileextension=="jpeg" || $this->fileextension=="jpg"){
			imagejpeg($this->image,"",$this->quality);			
		}elseif($this->fileextension=="gif"){
			$image=imagegif($this->image);
		}elseif($this->fileextension=="png"){
			$image=imagepng($this->image);
		}else{
			die("Nie można utworzyć obrazu.");
		}
	}
////////////////////////////////////////////////////////
	function getMimeType(){
		return $this->mimetype;
	}
////////////////////////////////////////////////////////
	function getQuality(){
		$quality;
		if($this->fileextension=="jpeg" || $this->fileextension=="jpg"){
			$quality=$this->quality;
		}else{
			$quality=-1;
		}
		return quality;
	}
////////////////////////////////////////////////////////
	function setQuality($quality){
		if($quality > 100 || $quality < 1)
			$quality=75;
		if($this->mimetype=="image/jpeg"){
			$this->quality=$quality;
		}
	}
////////////////////////////////////////////////////////
	function destroy(){
		imagedestroy($this->image);
	}
////////////////////////////////////////////////////////
//metody prywatne
////////////////////////////////////////////////////////
	function setMimeType($extension){
		if($extension=="jpeg" || $extension=="jpg"){
			$this->mimetype="image/jpeg";
		}elseif($extension=="png"){
			$this->mimetype="image/png";
		}elseif($extension=="gif"){
			$this->mimetype="image/gif";
		}else{
			die ("Not a recognized type.");
		}
	}
////////////////////////////////////////////////////////
	function createThumb(){
		$srcW=$this->imageproperties[0];
		$srcH=$this->imageproperties[1];
		//dopasowuje jedynie, jeśli większy niż rozmiar redukcji
		if($srcW>$this->maxdimension || $srcH>$this->maxdimension){
			$reduction=$this->calculateReduction($srcW,$srcH);
			//pobiera proporcje
  		$desW=round($srcW/$reduction);
  		$desH=round($srcH/$reduction);
			//sprawdza, czy plik gif
			//tworzy kopię
			if($this->mimetype=="image/gif"){
				$copy=imagecreate($desW, $desH);
			}else{
				$copy=imagecreatetruecolor($desW, $desH);
			}
			imagecopyresampled($copy,$this->image,0,0,0,0,$desW, $desH, $srcW, $srcH)
				 or die ("Kopiowanie pliku nie powiodło się.");
			//niszczy oryginał
			imagedestroy($this->image);
			$this->image=$copy;			
		}
	}
////////////////////////////////////////////////////////
	function calculateReduction($srcW, $srcH){
		//dopasowuje
  	if($srcW<$srcH){
  		$reduction=$srcH/$this->maxdimension;
  	}else{  			
  		$reduction=$srcW/$this->maxdimension;
  	}
		return $reduction;
	}
}//koniec klasy
////////////////////////////////////////////////////////
?>
