﻿<?php
////////////////////////////////////////////////////////////////////
class PageNavigator{
    //dane składowe
    private $pagename;
    private $totalpages;
    private $recordsperpage;
    private $maxpagesshown;
    private $currentstartpage;
    private $currentendpage;
    private $currentpage;
    //następna i poprzednia - nieaktywne
    private $spannextinactive;
    private $spanpreviousinactive;
    //pierwsza i ostatnia - nieaktywne
    private $firstinactivespan;
    private $lastinactivespan;    
    //musi odpowiadać $_GET['offset'] na wywoływanej stronie
    private $firstparamname="offset";
    //wykorzystane do pobrania jako para "&name=value"
    private $params;
    //nazwy klasy css
    private $inactivespanname = "inactive";
    private $pagedisplaydivname = "totalpagesdisplay";
    private $divwrappername = "navigator";
    //tekst
    private $strfirst = "|&lt;";
    private $strnext = "Natępna";
    private $strprevious = "Popzednia";
    private $strlast = "&gt;|";
    //zgłaszanie błędów
    private $errorstring;
////////////////////////////////////////////////////////////////////
//konstruktor
////////////////////////////////////////////////////////////////////
    public function __construct($pagename, $totalrecords, $recordsperpage, $recordoffset, $maxpagesshown=4, $params=""){
        $this->pagename=$pagename;
      $this->maxpagesshown=$this->checkMaxPagesShown($maxpagesshown);
      $this->maxpagesshown=$maxpagesshown;
      //już zakodowane jako url
      $this->params=$params;
      //sprawdza czy recordoffset jest wielokrotnością recordsperpage
        if(!$this->checkRecordoffset($recordoffset, $recordsperpage)){
          throw new Exception($this->errorstring);
    }
        $this->setTotalPages($totalrecords, $recordsperpage);
        $this->calculateCurrentPage($recordoffset, $recordsperpage);
        $this->createInactiveSpans();    
        $this->calculateCurrentStartPage();
        $this->calculateCurrentEndPage();
  }
////////////////////////////////////////////////////////////////////
//metody publiczne
////////////////////////////////////////////////////////////////////
//nadaje klasie css nazwę nieaktywnej przestrzeni
////////////////////////////////////////////////////////////////////
  public function setInactiveSpanName($name){
      $this->inactivespanname=$name;
        //wywołuje funkcję zmieniającą nazwę przestrzni
        $this->createInactiveSpans();    
  }
////////////////////////////////////////////////////////////////////
  public function getInactiveSpanName(){
      return $this->inactivespanname;
  }
////////////////////////////////////////////////////////////////////
  public function setPageDisplayDivName($name){
      $this->pagedisplaydivname=$name;        
  }
////////////////////////////////////////////////////////////////////
  public function getPageDisplayDivName(){
      return $this->pagedisplaydivname;
  }
////////////////////////////////////////////////////////////////////
  public function setDivWrapperName($name){
      $this->divwrappername=$name;        
  }
////////////////////////////////////////////////////////////////////
    public function getDivWrapperName(){
      return $this->divwrappername;
  }
////////////////////////////////////////////////////////////////////
    public function setFirstParamName($name){
      $this->firstparamname=$name;        
  }
////////////////////////////////////////////////////////////////////
    public function getFirstParamName(){
      return $this->firstparamname;
  }
////////////////////////////////////////////////////////////////////
    public function getNavigator(){
        //wrap in div tag
        $strnavigator= "<div class=\"$this->divwrappername\">\n";
        //wyświetla przycisk przejścia do pierwszej strony
        if($this->currentpage==0){
            $strnavigator.=$this->firstinactivespan;            
        }else{
            $strnavigator .= $this->createLink(0, $this->strfirst);
        }
        //wyświetla przycisk przejścia do poprzedniej strony
        if($this->currentpage==0){
            $strnavigator.= $this->spanpreviousinactive;            
        }else{
            $strnavigator.= $this->createLink($this->currentpage-1, $this->strprevious);
        }
        //sprawdza, czy jest tylko jedna strona
        if($this->maxpagesshown > 1){
            //sprawdza w pętli wyświetlone strony rozpoczynając od $currentstart
            for($x=$this->currentstartpage;$x<$this->currentendpage;$x++){
                //bieżąca strona nieaktywna
                if($x==$this->currentpage){
                    $strnavigator.= "<span class=\"$this->inactivespanname\">";
                    $strnavigator.= $x+1;
                    $strnavigator.= "</span>\n";
                }else{
                    $strnavigator.= $this->createLink($x, $x+1);
                }
            }
        }
        //przycisk "następna"   
        if($this->currentpage==$this->totalpages-1){
            $strnavigator.=$this->spannextinactive;            
        }else{
            $strnavigator.=$this->createLink($this->currentpage + 1, $this->strnext);
        }
        //przejdź do ostatniej
        if($this->currentpage==$this->totalpages-1){
            $strnavigator.= $this->lastinactivespan;            
        }else{
            $strnavigator.=$this->createLink($this->totalpages -1, $this->strlast);
        }
        $strnavigator.= "</div>\n";
        $strnavigator.=$this->getPageNumberDisplay();        
        return $strnavigator;
    }
////////////////////////////////////////////////////////////////////
//metody prywatne
////////////////////////////////////////////////////////////////////
    private function checkMaxPagesShown($num){
        if ($num < 1){
            throw new Exception("Pokazywane strony muszą mieć nr 1 lub wyższy.");
        }
        return $num;
    }
////////////////////////////////////////////////////////////////////
    private function createLink($offset, $strdisplay ){
        $strtemp= "<a href=\"$this->pagename?$this->firstparamname=";
        $strtemp.= $offset;
        $strtemp.= "$this->params\">$strdisplay</a>\n";
        return $strtemp;
    }
////////////////////////////////////////////////////////////////////    
    private function getPageNumberDisplay(){
        $str= "<div class=\"$this->pagedisplaydivname\">\nStrona ";
        $str.=$this->currentpage+1;
        $str.= " z $this->totalpages";
        $str.= "</div>\n";
        return $str;
    }
////////////////////////////////////////////////////////////////////
  private function setTotalPages($totalrecords, $recordsperpage){
      $this->totalpages=ceil($totalrecords/$recordsperpage);
  }
////////////////////////////////////////////////////////////////////
    private function checkRecordoffset($recordoffset, $recordsperpage){
        $bln=true;
        //jeśli recordoffset=0 nie wyświetli błędu
        if($recordoffset%$recordsperpage!=0){
            $this->errorstring="Błąd - nie jest wielokrotnością liczby elementów na stronę.";
            $bln=false;    
        }
        return $bln;
    }
////////////////////////////////////////////////////////////////////    
    private function calculateCurrentPage($recordoffset, $recordsperpage){
        $this->currentpage=$recordoffset/$recordsperpage;
    }
////////////////////////////////////////////////////////////////////
// nie zawsze potzebna
////////////////////////////////////////////////////////////////////
    private function createInactiveSpans(){
        $this->spannextinactive="<span class=\"".
            "$this->inactivespanname\">$this->strnext</span>\n";
        $this->lastinactivespan="<span class=\"".
            "$this->inactivespanname\">$this->strlast</span>\n";
        $this->spanpreviousinactive="<span class=\"".
            "$this->inactivespanname\">$this->strprevious</span>\n";
        $this->firstinactivespan="<span class=\"".
            "$this->inactivespanname\">$this->strfirst</span>\n";
    }
////////////////////////////////////////////////////////////////////
// znajduje stronę startową bazując na aktualnej stronie
////////////////////////////////////////////////////////////////////
    private function calculateCurrentStartPage(){
        $temp = floor($this->currentpage/$this->maxpagesshown);
        $this->currentstartpage=$temp * $this->maxpagesshown;
    }
////////////////////////////////////////////////////////////////////
    private function calculateCurrentEndPage(){
        $this->currentendpage = $this->currentstartpage+$this->maxpagesshown;
        if($this->currentendpage > $this->totalpages)
            $this->currentendpage = $this->totalpages;    
    }
}//koniec klasy
////////////////////////////////////////////////////////////////////
?>
